/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundev79.MineBootFramework.MineBootShell.builtin;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.AnsiFormat;
import com.diogonunes.jcolor.Attribute;
import com.github.sundev79.MineBootFramework.MineBootShell.MineBootCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.MineBootShell;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.MineBootShellCommandType;
import java.util.Map;

public class MineBootHelpCommand
extends MineBootCommand {
    public MineBootHelpCommand() {
        super("help", MineBootShellCommandType.BASIC);
        this.setEventHandler(this::help);
        this.setCommandDetails("Show help");
        System.out.println();
        System.out.println("\nWelcome to MineBoot_Shell !");
        System.out.println("Type \"" + this.getCommandName() + "\" for help.");
    }

    private void help() {
        System.out.println("\nMineBoot_Shell Commands : \n");
        this.parseCommands(MineBootShellCommandType.BASIC);
        if (MineBootShell.isCoreUtilsEnabled()) {
            System.out.println("\nCoreUtils Commands : \n");
            this.parseCommands(MineBootShellCommandType.CORE_UTILS);
        }
    }

    private void parseCommands(MineBootShellCommandType commandType) {
        for (Map.Entry<String, MineBootCommand> cmd : MineBootHelpCommand.getCommands().entrySet()) {
            if (!cmd.getValue().getCommandType().equals((Object)commandType)) continue;
            System.out.println(Ansi.colorize((String)cmd.getValue().getCommandName(), (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.BRIGHT_RED_TEXT()})) + " - " + cmd.getValue().getCommandDetails());
        }
    }
}

