/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundev79.MineBootFramework.MineBootShell.builtin.core;

import com.github.sundev79.MineBootFramework.MineBootShell.MineBootCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.MineBootShell;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.MineBootShellCommandType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystemException;

public class MineBootCdCommand
extends MineBootCommand {
    private File checkFile = null;

    public MineBootCdCommand() {
        super("cd", MineBootShellCommandType.CORE_UTILS);
        this.setEventHandler(() -> {
            try {
                this.cd(this.getCommandArgs().isEmpty() ? "" : this.getCommandArgs().get(0));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void cd(String path) throws IOException {
        if (path.isEmpty() || path.startsWith("~")) {
            this.checkFile = new File(System.getProperty("user.home") + "/" + path.replace("~", ""));
            if (this.checkFile.exists() && this.checkFile.canRead()) {
                MineBootShell.setPwdFile(this.checkFile);
            }
        }
        if (path.startsWith("/")) {
            this.checkFile = new File(path);
            if (this.checkFile.exists() && this.checkFile.canRead()) {
                MineBootShell.setPwdFile(this.checkFile);
            }
        }
        if (!path.startsWith("/")) {
            this.checkFile = new File(MineBootShell.getPwdFile() + "/" + path);
            if (this.checkFile.exists() && this.checkFile.canRead()) {
                MineBootShell.setPwdFile(this.checkFile);
            }
        }
        assert (this.checkFile != null);
        if (!this.checkFile.exists()) {
            throw new FileNotFoundException();
        }
        if (!this.checkFile.canRead()) {
            throw new FileSystemException("Access Denied");
        }
    }
}

