/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.DefaultRequestExpectationBuilder;
import com.github.tashoyan.httpspy.DefaultResponseBuilder;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.JsonEqualMatcher;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.RequestExpectationBuilder;
import com.github.tashoyan.httpspy.RequestExpectationListBuilder;
import com.github.tashoyan.httpspy.ResponseBuilder;
import com.github.tashoyan.httpspy.ValueExpectation;
import com.github.tashoyan.httpspy.XmlEqualMatcher;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

@NotThreadSafe
public abstract class AbstractRequestExpectationListBuilder
implements RequestExpectationListBuilder {
    private final List<RequestExpectation> requestExpectations = new ArrayList<RequestExpectation>(1000);
    private final List<HttpResponse> responses = new ArrayList<HttpResponse>(1000);

    @Override
    public List<RequestExpectation> getRequestExpectations() {
        return this.requestExpectations;
    }

    @Override
    public List<HttpResponse> getResponses() {
        return this.responses;
    }

    @Override
    public void expect(RequestExpectationBuilder requestExpectationBuilder) {
        Validate.notNull((Object)requestExpectationBuilder, (String)"requestExpectationBuilder must not be null", (Object[])new Object[0]);
        RequestExpectation requestExpectation = requestExpectationBuilder.build();
        ResponseBuilder responseBuilder = requestExpectationBuilder.getResponseBuilder();
        HttpResponse response = responseBuilder.build();
        this.requestExpectations.add(requestExpectation);
        this.responses.add(response);
    }

    public void expect(int times, RequestExpectationBuilder requestExpectationBuilder) {
        Validate.isTrue((times > 0 ? 1 : 0) != 0, (String)"times must be positive", (Object[])new Object[0]);
        Validate.notNull((Object)requestExpectationBuilder, (String)"requestExpectationBuilder must not be null", (Object[])new Object[0]);
        RequestExpectation requestExpectation = requestExpectationBuilder.build();
        ResponseBuilder responseBuilder = requestExpectationBuilder.getResponseBuilder();
        HttpResponse response = responseBuilder.build();
        for (int i = 0; i < times; ++i) {
            this.requestExpectations.add(requestExpectation);
            this.responses.add(response);
        }
    }

    @Override
    public RequestExpectationBuilder request() {
        return new DefaultRequestExpectationBuilder();
    }

    @Override
    public ResponseBuilder response() {
        return new DefaultResponseBuilder();
    }

    public static ValueExpectation equalToXml(String value) {
        return () -> new XmlEqualMatcher(value);
    }

    public static ValueExpectation equalToJson(String value) {
        return () -> new JsonEqualMatcher(value);
    }

    public static ValueExpectation equalTo(String value) {
        return () -> CoreMatchers.equalTo((Object)value);
    }

    public static ValueExpectation equalToIgnoreCase(final String value) {
        return () -> new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String actualValue) {
                return StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)actualValue);
            }

            public void describeTo(Description description) {
                description.appendText(value + " (ignoring case)");
            }
        };
    }

    public static ValueExpectation matching(Matcher<String> valueMatcher) {
        return () -> valueMatcher;
    }
}

