/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.HttpRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.camel.Exchange;
import org.apache.camel.http.common.HttpMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

@Immutable
@ThreadSafe
public class CamelJettyHttpRequest
implements HttpRequest {
    private static final int USUAL_HEADERS_NUMBER = 10;
    private static final int USUAL_HEADER_VALUES = 1;
    private final String method;
    private final String path;
    private final String body;
    private final Map<String, List<String>> headers;

    public CamelJettyHttpRequest(Exchange exchange) throws IOException {
        Validate.notNull((Object)exchange, (String)"Exchange must not be null", (Object[])new Object[0]);
        HttpMessage httpMessage = (HttpMessage)exchange.getIn(HttpMessage.class);
        if (httpMessage == null) {
            throw new IllegalArgumentException("Exchange does not have HTTP In message");
        }
        this.body = (String)httpMessage.getBody(String.class);
        HttpServletRequest request = httpMessage.getRequest();
        this.method = request.getMethod();
        this.path = request.getPathInfo();
        this.headers = Collections.unmodifiableMap(this.extractHeaders(request));
    }

    private Map<String, List<String>> extractHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>(10);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.computeIfAbsent(headerName, key -> new ArrayList(1)).add(headerValue);
            }
        }
        return requestHeaders;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        return CollectionUtils.isEmpty(values) ? null : Collections.unmodifiableList(values);
    }
}

