/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.CamelJettyHttpRequest;
import com.github.tashoyan.httpspy.CamelJettyHttpResponse;
import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.HttpSpy;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.RequestExpectationListBuilder;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jetty9.JettyHttpComponent9;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@NotThreadSafe
public class CamelJettyHttpSpy
implements HttpSpy {
    protected static final String DEFAULT_HOSTNAME = "localhost";
    protected static final int DEFAULT_SERVICE_THREADS_NUMBER = 1;
    static final int DEFAULT_REQUESTS_NUMBER = 1000;
    private static final int JETTY_INTERNAL_THREADS_NUMBER = 8;
    private static final String PATH_SEPARATOR = "/";
    private static final String DEFAULT_PATH = "/";
    private static final String SPY_ROUTE_NAME = "spy-server-consumer";
    private final CamelContext camelContext;
    private final String hostname;
    private final int port;
    private final String path;
    private int serviceThreadsNumber = 1;
    private boolean isStarted;
    private final List<RequestExpectation> requestExpectations = new ArrayList<RequestExpectation>(1000);
    private final List<HttpRequest> actualRequests = new ArrayList<HttpRequest>(1000);
    private final List<HttpResponse> responses = new ArrayList<HttpResponse>(1000);

    public CamelJettyHttpSpy(int port, String path) {
        this(DEFAULT_HOSTNAME, port, path);
    }

    public CamelJettyHttpSpy(String hostname, int port, String path) {
        Validate.notBlank((CharSequence)hostname, (String)"hostname must not be blank", (Object[])new Object[0]);
        Validate.isTrue((port > 0 ? 1 : 0) != 0, (String)"port must be > 0", (Object[])new Object[0]);
        this.camelContext = new DefaultCamelContext();
        this.hostname = hostname;
        this.port = port;
        this.path = this.normalizedPath(path);
    }

    private String normalizedPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "/";
        }
        if (StringUtils.contains((CharSequence)path, (int)32)) {
            throw new IllegalArgumentException("HTTP path must not contain spaces: " + path);
        }
        String normalizedPath = path;
        if (!path.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        if (!path.endsWith("/")) {
            normalizedPath = normalizedPath + "/";
        }
        return normalizedPath;
    }

    protected int getRealJettyThreadsNumber() {
        return this.getServiceThreadsNumber() + 8;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setServiceThreadsNumber(int serviceThreadsNumber) {
        Validate.isTrue((serviceThreadsNumber > 0 ? 1 : 0) != 0, (String)"threadsNumber must be > 0", (Object[])new Object[0]);
        if (this.isStarted) {
            throw new IllegalStateException("Spy server has already started");
        }
        this.serviceThreadsNumber = serviceThreadsNumber;
    }

    @Override
    public int getServiceThreadsNumber() {
        return this.serviceThreadsNumber;
    }

    @Override
    public HttpSpy expectRequests(RequestExpectationListBuilder builder) {
        builder.build();
        Validate.isTrue((builder.getRequestExpectations().size() == builder.getResponses().size() ? 1 : 0) != 0, (String)"requestExpectations and responses must have the same size", (Object[])new Object[0]);
        this.requestExpectations.addAll(builder.getRequestExpectations());
        this.responses.addAll(builder.getResponses());
        this.actualRequests.clear();
        return this;
    }

    @Override
    public void start() {
        if (this.isStarted) {
            throw new IllegalStateException("Spy server has already started");
        }
        this.isStarted = true;
        try {
            this.camelContext.start();
            JettyHttpComponent9 jettyComponent = (JettyHttpComponent9)this.camelContext.getComponent("jetty", JettyHttpComponent9.class);
            jettyComponent.setMinThreads(Integer.valueOf(this.getRealJettyThreadsNumber()));
            jettyComponent.setMaxThreads(Integer.valueOf(this.getRealJettyThreadsNumber()));
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(this.camelContext){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("jetty:http://" + CamelJettyHttpSpy.this.getHostname() + ":" + CamelJettyHttpSpy.this.getPort() + CamelJettyHttpSpy.this.getPath() + "?sendServerVersion=false" + "&chunked=false" + "&disableStreamCache=true").process(CamelJettyHttpSpy.this.createSpyProcessor())).setId(CamelJettyHttpSpy.SPY_ROUTE_NAME);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while setting up Camel context", e);
        }
    }

    protected Processor createSpyProcessor() {
        Processor processor = exchange -> {
            CamelJettyHttpResponse response;
            CamelJettyHttpRequest actualRequest = new CamelJettyHttpRequest(exchange);
            CamelJettyHttpSpy camelJettyHttpSpy = this;
            synchronized (camelJettyHttpSpy) {
                this.actualRequests.add(actualRequest);
                if (this.responses.isEmpty()) {
                    throw new AssertionError((Object)("No responses anymore; exptected requests: " + this.requestExpectations.size() + "; actually received requests: " + this.actualRequests.size() + " actual request: " + actualRequest));
                }
                response = (CamelJettyHttpResponse)this.responses.remove(0);
            }
            try {
                response.sendInExchange(exchange);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        };
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() {
        int actualRequestsNumber;
        CamelJettyHttpSpy camelJettyHttpSpy = this;
        synchronized (camelJettyHttpSpy) {
            actualRequestsNumber = this.actualRequests.size();
        }
        if (this.requestExpectations.size() != actualRequestsNumber) {
            throw new AssertionError((Object)("Number of actually received requests " + actualRequestsNumber + " should equal the number of request expected " + this.requestExpectations.size()));
        }
        int i = 0;
        for (RequestExpectation requestExpectation : this.requestExpectations) {
            Matcher<HttpRequest> requestMatcher = requestExpectation.getRequestMatcher();
            HttpRequest actualRequest = this.actualRequests.get(i);
            MatcherAssert.assertThat((String)("Request #" + i + " should match expectation"), (Object)actualRequest, requestMatcher);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CamelJettyHttpSpy camelJettyHttpSpy = this;
        synchronized (camelJettyHttpSpy) {
            this.requestExpectations.clear();
            this.actualRequests.clear();
            this.responses.clear();
        }
    }

    @Override
    public void stop() {
        this.isStarted = false;
        this.reset();
        try {
            this.camelContext.stop();
            this.camelContext.removeRoute(SPY_ROUTE_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while shutting down Camel context", e);
        }
    }
}

