/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.CamelJettyHttpResponse;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.ResponseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.Validate;

@NotThreadSafe
public class DefaultResponseBuilder
implements ResponseBuilder {
    private static final int USUAL_HEADERS_NUMBER = 10;
    private static final int USUAL_HEADER_VALUES = 1;
    private int statusCode = 200;
    private String body = "";
    private Map<String, List<String>> headers = new HashMap<String, List<String>>(10);
    private long delayMillis = 0L;

    protected DefaultResponseBuilder() {
    }

    @Override
    public HttpResponse build() {
        return new CamelJettyHttpResponse(this.statusCode, this.body, this.headers, this.delayMillis);
    }

    @Override
    public ResponseBuilder withStatus(int statusCode) {
        Validate.isTrue((statusCode > 0 ? 1 : 0) != 0, (String)"statusCode must be positive", (Object[])new Object[0]);
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public ResponseBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    public ResponseBuilder withHeader(String headerName, String headerValue) {
        Validate.notBlank((CharSequence)headerName, (String)"headerName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)headerValue, (String)"headerValue must not be null", (Object[])new Object[0]);
        this.headers.computeIfAbsent(headerName, key -> new ArrayList(1)).add(headerValue);
        return this;
    }

    @Override
    public ResponseBuilder withDelay(TimeUnit timeUnit, long delay) {
        Validate.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null", (Object[])new Object[0]);
        Validate.isTrue((delay >= 0L ? 1 : 0) != 0, (String)"delay must not be negative", (Object[])new Object[0]);
        this.delayMillis = timeUnit.toMillis(delay);
        return this;
    }
}

