/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.ValueExpectation;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
@ThreadSafe
public class HttpRequestHeaderMatcher
extends TypeSafeMatcher<HttpRequest> {
    private final String headerName;
    private final ValueExpectation valueExpectation;

    public HttpRequestHeaderMatcher(String headerName, ValueExpectation valueExpectation) {
        Validate.notBlank((CharSequence)headerName, (String)"headerName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)valueExpectation, (String)"valueExpectation must not be null", (Object[])new Object[0]);
        this.headerName = headerName;
        this.valueExpectation = valueExpectation;
    }

    public boolean matchesSafely(HttpRequest httpRequest) {
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        List<String> headerValues = actualHeaders.get(this.headerName);
        if (CollectionUtils.isEmpty(headerValues)) {
            return false;
        }
        return headerValues.stream().anyMatch(headerValue -> this.valueExpectation.getMatcher().matches(headerValue));
    }

    public void describeTo(Description description) {
        description.appendText("[header " + this.headerName + " : ");
        description.appendDescriptionOf(this.valueExpectation.getMatcher());
        description.appendText("]");
    }

    public void describeMismatchSafely(HttpRequest httpRequest, Description description) {
        description.appendText("was ");
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        List<String> headerValues = actualHeaders.get(this.headerName);
        if (headerValues == null) {
            description.appendText("no such header: " + this.headerName);
            return;
        }
        description.appendValue(headerValues);
    }
}

