/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

@Immutable
@ThreadSafe
public class JsonEqualMatcher
extends TypeSafeMatcher<String> {
    private final String expectedValue;

    public JsonEqualMatcher(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public boolean matchesSafely(String actualValue) {
        if (StringUtils.isEmpty((CharSequence)this.expectedValue)) {
            return Objects.equals(this.expectedValue, actualValue);
        }
        try {
            JSONCompareResult result = JSONCompare.compareJSON((String)this.expectedValue, (String)actualValue, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
            return result.passed();
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot compare expected value: " + this.expectedValue + " and actual value: " + actualValue, e);
        }
    }

    public void describeTo(Description description) {
        description.appendText("[equals JSON : ");
        description.appendValue((Object)this.expectedValue);
        description.appendText("]");
    }

    public void describeMismatchSafely(String actualValue, Description description) {
        if (StringUtils.isEmpty((CharSequence)this.expectedValue)) {
            description.appendText("was ").appendText(actualValue);
            return;
        }
        try {
            JSONCompareResult result = JSONCompare.compareJSON((String)this.expectedValue, (String)actualValue, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
            description.appendText("was ").appendText(result.getMessage());
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot compare expected value: " + this.expectedValue + " and actual value: " + actualValue, e);
        }
    }
}

