/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.HttpRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
@ThreadSafe
public class StrictHeadersMatcher
extends TypeSafeMatcher<HttpRequest> {
    private final Set<String> specifiedHeaders;

    public StrictHeadersMatcher(Set<String> specifiedHeaders) {
        Validate.notNull(specifiedHeaders, (String)"specifiedHeaders must not be null", (Object[])new Object[0]);
        this.specifiedHeaders = Collections.unmodifiableSet(specifiedHeaders);
    }

    public boolean matchesSafely(HttpRequest httpRequest) {
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        if (MapUtils.isEmpty(actualHeaders)) {
            return this.specifiedHeaders.isEmpty();
        }
        return this.specifiedHeaders.size() == actualHeaders.keySet().size() && this.specifiedHeaders.containsAll(actualHeaders.keySet());
    }

    public void describeTo(Description description) {
        description.appendText("[strict headers : ");
        description.appendValue(this.specifiedHeaders);
        description.appendText("]");
    }

    public void describeMismatchSafely(HttpRequest httpRequest, Description description) {
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        description.appendText("was ").appendValue(actualHeaders);
    }
}

