/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import java.io.IOException;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.xml.sax.SAXException;

@Immutable
@ThreadSafe
public class XmlEqualMatcher
extends TypeSafeMatcher<String> {
    private final String expectedValue;

    public XmlEqualMatcher(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public boolean matchesSafely(String actualValue) {
        if (StringUtils.isEmpty((CharSequence)this.expectedValue)) {
            return Objects.equals(this.expectedValue, actualValue);
        }
        try {
            Diff diff = new Diff(this.expectedValue, actualValue);
            return diff.similar();
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Cannot calculate diff between expected value: " + this.expectedValue + " and actual value: " + actualValue, e);
        }
    }

    public void describeTo(Description description) {
        description.appendText("[equals XML : ");
        description.appendValue((Object)this.expectedValue);
        description.appendText("]");
    }

    public void describeMismatchSafely(String actualValue, Description description) {
        if (StringUtils.isEmpty((CharSequence)this.expectedValue)) {
            description.appendText("was ").appendText(actualValue);
            return;
        }
        try {
            Diff diff = new Diff(this.expectedValue, actualValue);
            description.appendText("was ").appendText(diff.toString());
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Cannot calculate diff between expected value: " + this.expectedValue + " and actual value: " + actualValue, e);
        }
    }

    static {
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setCompareUnmatched((boolean)true);
    }
}

