/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.AbstractTestPlanBuilder;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.RequestExpectationBuilder;
import com.github.tashoyan.httpspy.ResponseBuilder;
import com.github.tashoyan.httpspy.SequencePlan;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.Validate;

@NotThreadSafe
public abstract class AbstractSequencePlanBuilder
extends AbstractTestPlanBuilder<SequencePlan> {
    private final List<RequestExpectation> requestExpectations = new ArrayList<RequestExpectation>(1000);
    private final List<HttpResponse> responses = new ArrayList<HttpResponse>(1000);

    @Override
    public void expect(RequestExpectationBuilder requestExpectationBuilder) {
        Validate.notNull((Object)requestExpectationBuilder, (String)"requestExpectationBuilder must not be null", (Object[])new Object[0]);
        RequestExpectation requestExpectation = requestExpectationBuilder.build();
        ResponseBuilder responseBuilder = requestExpectationBuilder.getResponseBuilder();
        HttpResponse response = responseBuilder.build();
        this.requestExpectations.add(requestExpectation);
        this.responses.add(response);
    }

    public void expect(int times, RequestExpectationBuilder requestExpectationBuilder) {
        Validate.isTrue((times > 0 ? 1 : 0) != 0, (String)"times must be positive", (Object[])new Object[0]);
        Validate.notNull((Object)requestExpectationBuilder, (String)"requestExpectationBuilder must not be null", (Object[])new Object[0]);
        RequestExpectation requestExpectation = requestExpectationBuilder.build();
        ResponseBuilder responseBuilder = requestExpectationBuilder.getResponseBuilder();
        HttpResponse response = responseBuilder.build();
        for (int i = 0; i < times; ++i) {
            this.requestExpectations.add(requestExpectation);
            this.responses.add(response);
        }
    }

    @Override
    public SequencePlan build() {
        this.compose();
        return new SequencePlan(this.requestExpectations, this.responses);
    }

    public abstract void compose();
}

