/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.AbstractTestPlanBuilder;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.RequestExpectationBuilder;
import com.github.tashoyan.httpspy.ResponseBuilder;
import com.github.tashoyan.httpspy.StubPlan;
import java.util.Deque;
import java.util.LinkedList;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.Validate;

@NotThreadSafe
public abstract class AbstractStubPlanBuilder
extends AbstractTestPlanBuilder<StubPlan> {
    private final Deque<RequestExpectation> requestExpectations = new LinkedList<RequestExpectation>();
    private final Deque<HttpResponse> responses = new LinkedList<HttpResponse>();

    @Override
    public void expect(RequestExpectationBuilder requestExpectationBuilder) {
        Validate.notNull((Object)requestExpectationBuilder, (String)"requestExpectationBuilder must not be null", (Object[])new Object[0]);
        RequestExpectation requestExpectation = requestExpectationBuilder.build();
        ResponseBuilder responseBuilder = requestExpectationBuilder.getResponseBuilder();
        HttpResponse response = responseBuilder.build();
        this.requestExpectations.addFirst(requestExpectation);
        this.responses.addFirst(response);
    }

    @Override
    public StubPlan build() {
        this.compose();
        return new StubPlan(this.requestExpectations, this.responses);
    }

    public abstract void compose();
}

