/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.DefaultRequestExpectationBuilder;
import com.github.tashoyan.httpspy.DefaultResponseBuilder;
import com.github.tashoyan.httpspy.RequestExpectationBuilder;
import com.github.tashoyan.httpspy.ResponseBuilder;
import com.github.tashoyan.httpspy.TestPlan;
import com.github.tashoyan.httpspy.TestPlanBuilder;
import com.github.tashoyan.httpspy.ValueExpectation;
import com.github.tashoyan.httpspy.matcher.JsonEqualMatcher;
import com.github.tashoyan.httpspy.matcher.XmlEqualMatcher;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

@NotThreadSafe
public abstract class AbstractTestPlanBuilder<T extends TestPlan>
implements TestPlanBuilder {
    protected static final int DEFAULT_REQUESTS_NUMBER = 1000;

    @Override
    public RequestExpectationBuilder request() {
        return new DefaultRequestExpectationBuilder();
    }

    @Override
    public ResponseBuilder response() {
        return new DefaultResponseBuilder();
    }

    public abstract T build();

    public static ValueExpectation equalToXml(String value) {
        return () -> new XmlEqualMatcher(value);
    }

    public static ValueExpectation equalToJson(String value) {
        return () -> new JsonEqualMatcher(value);
    }

    public static ValueExpectation equalTo(String value) {
        return () -> CoreMatchers.equalTo((Object)value);
    }

    public static ValueExpectation equalToIgnoreCase(final String value) {
        return () -> new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String actualValue) {
                return StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)actualValue);
            }

            public void describeTo(Description description) {
                description.appendText(value + " (ignoring case)");
            }
        };
    }

    public static ValueExpectation matching(Matcher<String> valueMatcher) {
        return () -> valueMatcher;
    }
}

