/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.HttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Immutable
@ThreadSafe
public class CamelJettyHttpResponse
implements HttpResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;
    private final long delayMillis;

    protected CamelJettyHttpResponse(int statusCode, String body, Map<String, List<String>> headers, long delayMillis) {
        Validate.isTrue((delayMillis >= 0L ? 1 : 0) != 0, (String)"delayMillis must be >= 0", (Object[])new Object[0]);
        this.statusCode = statusCode;
        this.body = body;
        this.delayMillis = delayMillis;
        if (MapUtils.isEmpty(headers)) {
            this.headers = Collections.emptyMap();
        } else {
            headers.forEach((headerName, headerValues) -> {
                Validate.notBlank((CharSequence)headerName, (String)"headerName must not be blank", (Object[])new Object[0]);
                Validate.notEmpty((Collection)headerValues, (String)("headerValues must not be null or empty, header: " + headerName), (Object[])new Object[0]);
                headerValues.forEach(headerValue -> {
                    String cfr_ignored_0 = (String)Validate.notNull((Object)headerValue, (String)("headerValue must not be null, header: " + headerName), (Object[])new Object[0]);
                });
            });
            this.headers = Collections.unmodifiableMap(new HashMap<String, List<String>>(headers));
        }
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public long getDelayMillis() {
        return this.delayMillis;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

