/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.CamelJettyHttpRequest;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.HttpSpy;
import com.github.tashoyan.httpspy.TestPlan;
import com.github.tashoyan.httpspy.TestPlanBuilder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jetty9.JettyHttpComponent9;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@NotThreadSafe
public class CamelJettyHttpSpy
implements HttpSpy {
    protected static final String DEFAULT_HOSTNAME = "localhost";
    protected static final int DEFAULT_SERVICE_THREADS_NUMBER = 1;
    private static final int JETTY_INTERNAL_THREADS_NUMBER = 8;
    private static final String PATH_SEPARATOR = "/";
    private static final String DEFAULT_PATH = "/";
    private static final String SPY_ROUTE_NAME = "spy-server-consumer";
    private final CamelContext camelContext;
    private final String hostname;
    private final int port;
    private final String path;
    private int serviceThreadsNumber = 1;
    private boolean isStarted;
    private final AtomicReference<TestPlan> testPlan = new AtomicReference();

    public CamelJettyHttpSpy(int port, String path) {
        this(DEFAULT_HOSTNAME, port, path);
    }

    public CamelJettyHttpSpy(String hostname, int port, String path) {
        Validate.notBlank((CharSequence)hostname, (String)"hostname must not be blank", (Object[])new Object[0]);
        Validate.isTrue((port > 0 ? 1 : 0) != 0, (String)"port must be > 0", (Object[])new Object[0]);
        this.camelContext = new DefaultCamelContext();
        this.hostname = hostname;
        this.port = port;
        this.path = this.normalizedPath(path);
    }

    private String normalizedPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "/";
        }
        if (StringUtils.contains((CharSequence)path, (int)32)) {
            throw new IllegalArgumentException("HTTP path must not contain spaces: " + path);
        }
        String normalizedPath = path;
        if (!path.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        if (!path.endsWith("/")) {
            normalizedPath = normalizedPath + "/";
        }
        return normalizedPath;
    }

    protected int getRealJettyThreadsNumber() {
        return this.getServiceThreadsNumber() + 8;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setServiceThreadsNumber(int serviceThreadsNumber) {
        Validate.isTrue((serviceThreadsNumber > 0 ? 1 : 0) != 0, (String)"threadsNumber must be > 0", (Object[])new Object[0]);
        if (this.isStarted) {
            throw new IllegalStateException("Spy server has already started");
        }
        TestPlan plan = this.testPlan.get();
        if (plan != null && !plan.isMultithreaded() && serviceThreadsNumber > 1) {
            throw new IllegalArgumentException("Current test plan " + plan + " does not support multiple service threads: " + serviceThreadsNumber);
        }
        this.serviceThreadsNumber = serviceThreadsNumber;
    }

    @Override
    public int getServiceThreadsNumber() {
        return this.serviceThreadsNumber;
    }

    @Override
    public HttpSpy testPlan(TestPlanBuilder testPlanBuilder) {
        Validate.notNull((Object)testPlanBuilder, (String)"testPlanBuilder must not be null", (Object[])new Object[0]);
        TestPlan plan = testPlanBuilder.build();
        if (!plan.isMultithreaded() && this.serviceThreadsNumber > 1) {
            throw new IllegalArgumentException("New test plan " + plan + " does not support multiple service threads: " + this.serviceThreadsNumber);
        }
        if (!this.testPlan.compareAndSet(null, plan)) {
            throw new IllegalStateException("Test plan is already set");
        }
        return this;
    }

    @Override
    public void start() {
        if (this.isStarted) {
            throw new IllegalStateException("Spy server has already started");
        }
        this.isStarted = true;
        try {
            this.camelContext.start();
            JettyHttpComponent9 jettyComponent = (JettyHttpComponent9)this.camelContext.getComponent("jetty", JettyHttpComponent9.class);
            jettyComponent.setMinThreads(Integer.valueOf(this.getRealJettyThreadsNumber()));
            jettyComponent.setMaxThreads(Integer.valueOf(this.getRealJettyThreadsNumber()));
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(this.camelContext){

                public void configure() {
                    ((RouteDefinition)this.from("jetty:http://" + CamelJettyHttpSpy.this.getHostname() + ":" + CamelJettyHttpSpy.this.getPort() + CamelJettyHttpSpy.this.getPath() + "?sendServerVersion=false" + "&chunked=false" + "&disableStreamCache=true").process(CamelJettyHttpSpy.this.createSpyProcessor())).setId(CamelJettyHttpSpy.SPY_ROUTE_NAME);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while setting up Camel context", e);
        }
    }

    protected Processor createSpyProcessor() {
        Processor processor = exchange -> {
            if (this.testPlan.get() == null) {
                throw new IllegalStateException("Test plan is not set");
            }
            CamelJettyHttpRequest actualRequest = new CamelJettyHttpRequest(exchange);
            HttpResponse response = this.testPlan.get().getResponse(actualRequest);
            try {
                this.sendResponseInExchange(response, exchange);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        };
        return processor;
    }

    protected void sendResponseInExchange(HttpResponse response, Exchange exchange) throws InterruptedException {
        Validate.notNull((Object)response, (String)"response must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)exchange, (String)"exchange must not be null", (Object[])new Object[0]);
        Message message = exchange.getOut();
        message.setHeader("CamelHttpResponseCode", (Object)response.getStatusCode());
        message.setHeader("CamelHttpCharacterEncoding", (Object)Charset.defaultCharset().name());
        message.setBody((Object)response.getBody(), String.class);
        response.getHeaders().entrySet().forEach(entry -> message.setHeader((String)entry.getKey(), (Object)((List)entry.getValue()).stream().collect(Collectors.joining(","))));
        Thread.sleep(response.getDelayMillis());
    }

    @Override
    public void verify() {
        if (this.testPlan.get() == null) {
            throw new IllegalStateException("Test plan is not set");
        }
        this.testPlan.get().verify();
    }

    @Override
    public void reset() {
        this.testPlan.set(null);
    }

    @Override
    public void stop() {
        this.isStarted = false;
        try {
            this.camelContext.stop();
            this.camelContext.removeRoute(SPY_ROUTE_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while shutting down Camel context", e);
        }
    }
}

