/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.DefaultRequestExpectation;
import com.github.tashoyan.httpspy.DefaultResponseBuilder;
import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.RequestExpectationBuilder;
import com.github.tashoyan.httpspy.ResponseBuilder;
import com.github.tashoyan.httpspy.ValueExpectation;
import com.github.tashoyan.httpspy.matcher.HttpRequestHeaderMatcher;
import com.github.tashoyan.httpspy.matcher.HttpRequestMatcher;
import com.github.tashoyan.httpspy.matcher.StrictHeadersMatcher;
import com.github.tashoyan.httpspy.matcher.WithoutHeaderRequestMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.Validate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

@NotThreadSafe
public class DefaultRequestExpectationBuilder
implements RequestExpectationBuilder {
    private static final int USUAL_SPECIFIED_MATCHERS_NUMBER = 10;
    private static final int USUAL_SPECIFIED_HEADERS_NUMBER = 10;
    private final List<Matcher<? super HttpRequest>> requestMatchers = new ArrayList<Matcher<? super HttpRequest>>(10);
    private final Set<String> specifiedHeaders = new HashSet<String>(10);
    private boolean isStrictHeaders;
    private ResponseBuilder responseBuilder = new DefaultResponseBuilder();

    protected DefaultRequestExpectationBuilder() {
    }

    @Override
    public RequestExpectation build() {
        if (this.isStrictHeaders) {
            this.requestMatchers.add((Matcher<? super HttpRequest>)new StrictHeadersMatcher(this.specifiedHeaders));
        }
        return new DefaultRequestExpectation((Matcher<HttpRequest>)CoreMatchers.allOf(this.requestMatchers));
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    protected RequestExpectationBuilder withRequestAttribute(Function<HttpRequest, Object> attributeProvider, String matcherName, ValueExpectation valueExpectation) {
        this.requestMatchers.add((Matcher<? super HttpRequest>)new HttpRequestMatcher(attributeProvider, valueExpectation, matcherName));
        return this;
    }

    @Override
    public RequestExpectationBuilder withMethod(ValueExpectation valueExpectation) {
        this.assertValueExpectationNotNull(valueExpectation);
        return this.withRequestAttribute(httpRequest -> httpRequest.getMethod(), "method", valueExpectation);
    }

    @Override
    public RequestExpectationBuilder withPath(ValueExpectation valueExpectation) {
        this.assertValueExpectationNotNull(valueExpectation);
        return this.withRequestAttribute(httpRequest -> httpRequest.getPath(), "path", valueExpectation);
    }

    @Override
    public RequestExpectationBuilder withBody(ValueExpectation valueExpectation) {
        this.assertValueExpectationNotNull(valueExpectation);
        return this.withRequestAttribute(httpRequest -> httpRequest.getBody(), "body", valueExpectation);
    }

    @Override
    public RequestExpectationBuilder withHeader(String headerName) {
        this.assertHeaderNameNotBlank(headerName);
        this.specifiedHeaders.add(headerName);
        this.requestMatchers.add((Matcher<? super HttpRequest>)new HttpRequestHeaderMatcher(headerName, () -> CoreMatchers.any(String.class)));
        return this;
    }

    @Override
    public RequestExpectationBuilder withHeader(String headerName, ValueExpectation valueExpectation) {
        this.assertValueExpectationNotNull(valueExpectation);
        this.assertHeaderNameNotBlank(headerName);
        this.specifiedHeaders.add(headerName);
        this.requestMatchers.add((Matcher<? super HttpRequest>)new HttpRequestHeaderMatcher(headerName, valueExpectation));
        return this;
    }

    @Override
    public RequestExpectationBuilder withHeader(String headerName, int valueIndex, ValueExpectation valueExpectation) {
        this.assertHeaderNameNotBlank(headerName);
        Validate.isTrue((valueIndex >= 0 ? 1 : 0) != 0, (String)("valueIndex must be >= 0: " + valueIndex), (Object[])new Object[0]);
        this.assertValueExpectationNotNull(valueExpectation);
        this.specifiedHeaders.add(headerName);
        return this.withRequestAttribute(httpRequest -> httpRequest.getHeaderValues(headerName).get(valueIndex), "header " + headerName + " - value index " + valueIndex, valueExpectation);
    }

    @Override
    public RequestExpectationBuilder withoutHeader(String headerName) {
        this.assertHeaderNameNotBlank(headerName);
        this.requestMatchers.add((Matcher<? super HttpRequest>)new WithoutHeaderRequestMatcher(headerName));
        return this;
    }

    @Override
    public RequestExpectationBuilder withStrictHeaders() {
        this.isStrictHeaders = true;
        return this;
    }

    @Override
    public RequestExpectationBuilder andResponse(ResponseBuilder responseBuilder) {
        Validate.notNull((Object)responseBuilder, (String)"responseBuilder must not be null", (Object[])new Object[0]);
        this.responseBuilder = responseBuilder;
        return this;
    }

    private void assertValueExpectationNotNull(ValueExpectation valueExpectation) {
        Validate.notNull((Object)valueExpectation, (String)"valueExpectation must not be null", (Object[])new Object[0]);
    }

    private void assertHeaderNameNotBlank(String headerName) {
        Validate.notBlank((CharSequence)headerName, (String)"headerName must not be blank", (Object[])new Object[0]);
    }
}

