/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.CamelJettyHttpResponse;
import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.TestPlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@NotThreadSafe
public class SequencePlan
implements TestPlan {
    private final List<RequestExpectation> requestExpectations;
    private final List<HttpResponse> responses;
    private final List<HttpRequest> actualRequests;

    public SequencePlan(List<RequestExpectation> requestExpectations, List<HttpResponse> responses) {
        Validate.notEmpty(requestExpectations, (String)"requestExpectations must not be null or empty", (Object[])new Object[0]);
        Validate.notEmpty(responses, (String)"requestExpectations must not be null or empty", (Object[])new Object[0]);
        Validate.isTrue((requestExpectations.size() == responses.size() ? 1 : 0) != 0, (String)"requestExpectations and responses must have the same size", (Object[])new Object[0]);
        this.requestExpectations = Collections.unmodifiableList(new ArrayList<RequestExpectation>(requestExpectations));
        this.responses = new ArrayList<HttpResponse>(responses);
        this.actualRequests = new ArrayList<HttpRequest>(requestExpectations.size());
    }

    @Override
    public HttpResponse getResponse(HttpRequest actualRequest) {
        Validate.notNull((Object)actualRequest, (String)"actualRequest must not be null", (Object[])new Object[0]);
        this.actualRequests.add(actualRequest);
        if (!this.responses.isEmpty()) {
            return this.responses.remove(0);
        }
        return this.createMissingResponse(actualRequest);
    }

    protected HttpResponse createMissingResponse(HttpRequest actualRequest) {
        Validate.notNull((Object)actualRequest, (String)"actualRequest must not be null", (Object[])new Object[0]);
        String msg = "No responses anymore; exptected requests: " + this.requestExpectations.size() + "; actually received requests: " + this.actualRequests.size() + " actual request: " + actualRequest;
        return new CamelJettyHttpResponse(500, msg, Collections.emptyMap(), 0L);
    }

    @Override
    public void verify() {
        int actualRequestsNumber = this.actualRequests.size();
        if (this.requestExpectations.size() != actualRequestsNumber) {
            throw new AssertionError((Object)("Number of actually received requests " + actualRequestsNumber + " should equal the number of request expected " + this.requestExpectations.size()));
        }
        int i = 0;
        for (RequestExpectation requestExpectation : this.requestExpectations) {
            Matcher<HttpRequest> requestMatcher = requestExpectation.getRequestMatcher();
            HttpRequest actualRequest = this.actualRequests.get(i);
            MatcherAssert.assertThat((String)("Request #" + i + " should match expectation"), (Object)actualRequest, requestMatcher);
            ++i;
        }
    }

    @Override
    public final boolean isMultithreaded() {
        return false;
    }
}

