/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy;

import com.github.tashoyan.httpspy.CamelJettyHttpResponse;
import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.HttpResponse;
import com.github.tashoyan.httpspy.RequestExpectation;
import com.github.tashoyan.httpspy.TestPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ThreadSafe
public class StubPlan
implements TestPlan {
    private final List<Pair<RequestExpectation, HttpResponse>> expectationsAndResponses;
    private final List<HttpRequest> unmatchedRequests;

    public StubPlan(Collection<RequestExpectation> requestExpectations, Collection<HttpResponse> responses) {
        Validate.notEmpty(requestExpectations, (String)"requestExpectations must not be null or empty", (Object[])new Object[0]);
        Validate.notEmpty(responses, (String)"requestExpectations must not be null or empty", (Object[])new Object[0]);
        Validate.isTrue((requestExpectations.size() == responses.size() ? 1 : 0) != 0, (String)"requestExpectations and responses must have the same size", (Object[])new Object[0]);
        ArrayList tmp = new ArrayList(requestExpectations.size());
        Iterator<HttpResponse> responseIt = responses.iterator();
        requestExpectations.stream().forEachOrdered(expectation -> tmp.add(new ImmutablePair(expectation, responseIt.next())));
        this.expectationsAndResponses = Collections.unmodifiableList(tmp);
        this.unmatchedRequests = Collections.synchronizedList(new ArrayList(requestExpectations.size()));
    }

    @Override
    public HttpResponse getResponse(HttpRequest actualRequest) {
        for (Pair<RequestExpectation, HttpResponse> p : this.expectationsAndResponses) {
            RequestExpectation expectation = (RequestExpectation)p.getLeft();
            if (!expectation.getRequestMatcher().matches((Object)actualRequest)) continue;
            return (HttpResponse)p.getRight();
        }
        this.recordUnmatchedRequest(actualRequest);
        return this.createUnmatchedRequestResponse(actualRequest);
    }

    protected void recordUnmatchedRequest(HttpRequest actualRequest) {
        Validate.notNull((Object)actualRequest, (String)"actualRequest must not be null", (Object[])new Object[0]);
        this.unmatchedRequests.add(actualRequest);
    }

    protected HttpResponse createUnmatchedRequestResponse(HttpRequest actualRequest) {
        Validate.notNull((Object)actualRequest, (String)"actualRequest must not be null", (Object[])new Object[0]);
        return new CamelJettyHttpResponse(500, "Unmatched request: " + actualRequest.toString(), Collections.emptyMap(), 0L);
    }

    @Override
    public void verify() {
        if (this.unmatchedRequests.isEmpty()) {
            return;
        }
        throw new AssertionError((Object)("Unmatched requests received:\n" + StringUtils.join(this.unmatchedRequests, (char)'\n')));
    }

    @Override
    public boolean isMultithreaded() {
        return true;
    }
}

