/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy.matcher;

import com.github.tashoyan.httpspy.HttpRequest;
import com.github.tashoyan.httpspy.ValueExpectation;
import java.util.function.Function;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
@ThreadSafe
public class HttpRequestMatcher
extends TypeSafeMatcher<HttpRequest> {
    private final Function<HttpRequest, Object> attributeProvider;
    private final ValueExpectation valueExpectation;
    private final String name;

    public HttpRequestMatcher(Function<HttpRequest, Object> attributeProvider, ValueExpectation valueExpectation, String name) {
        Validate.notNull(attributeProvider, (String)"attributeProvider must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)valueExpectation, (String)"valueExpectation must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)name, (String)"headerName must not be blank", (Object[])new Object[0]);
        this.attributeProvider = attributeProvider;
        this.valueExpectation = valueExpectation;
        this.name = name;
    }

    public boolean matchesSafely(HttpRequest httpRequest) {
        return this.valueExpectation.getMatcher().matches(this.attributeProvider.apply(httpRequest));
    }

    public void describeTo(Description description) {
        description.appendText("[" + this.name + " : ");
        description.appendDescriptionOf(this.valueExpectation.getMatcher());
        description.appendText("]");
    }

    public void describeMismatchSafely(HttpRequest httpRequest, Description description) {
        description.appendText("was ").appendValue(this.attributeProvider.apply(httpRequest));
    }
}

