/*
 * Decompiled with CFR 0.152.
 */
package com.github.tashoyan.httpspy.matcher;

import com.github.tashoyan.httpspy.HttpRequest;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
@ThreadSafe
public class WithoutHeaderRequestMatcher
extends TypeSafeMatcher<HttpRequest> {
    private final String headerName;

    public WithoutHeaderRequestMatcher(String headerName) {
        Validate.notBlank((CharSequence)headerName, (String)"headerName must not be blank", (Object[])new Object[0]);
        this.headerName = headerName;
    }

    public boolean matchesSafely(HttpRequest httpRequest) {
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        if (MapUtils.isEmpty(actualHeaders)) {
            return true;
        }
        return !actualHeaders.containsKey(this.headerName);
    }

    public void describeTo(Description description) {
        description.appendText("[without header : ");
        description.appendValue((Object)this.headerName);
        description.appendText("]");
    }

    public void describeMismatchSafely(HttpRequest httpRequest, Description description) {
        Map<String, List<String>> actualHeaders = httpRequest.getHeaders();
        List<String> headerValues = actualHeaders.get(this.headerName);
        description.appendText("was ").appendText(this.headerName).appendText(": ").appendValue(headerValues);
    }
}

