package com.github.taymindis;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * JspResponseWrapper responseWrapper = new JspResponseWrapper(response);
 *   request.getRequestDispatcher("/apps/kiehls_portal/redeem.jsp?crmid=" + custId + "&password=" + ecom_api_key +
 *   		"&type=voucher&balance="+balance+"&deductpoints="+redeemPoints+"&rewardid="+rewardId+"&outletid=" + outletid)
 *   		.include(new HttpServletRequestWrapper(request) {
 *   			@Override
 *   			public String getMethod() {
 *   				return "POST";
 *   			}
 *   		}, responseWrapper);
 *
 */
public class NonSuckJspResponseWrapper extends HttpServletResponseWrapper {

    private int httpStatus;
    private final StringWriter sw = new StringWriter();

    public NonSuckJspResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(sw);
    }

    @Override
    public String toString() {
        return sw.toString();
    }


    @Override
    public void sendError(int sc) throws IOException {
        httpStatus = sc;
        super.sendError(sc);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        httpStatus = sc;
        super.sendError(sc, msg);
    }


    @Override
    public void setStatus(int sc) {
        httpStatus = sc;
        super.setStatus(sc);
    }

    public int getStatus() {
        return httpStatus;
    }

}