/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api.COMB;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import testoptimal.api.COMB.Constraint;
import testoptimal.api.COMB.Field;
import testoptimal.api.COMB.Relation;
import testoptimal.api.Util;

public class DataSet {
    public static final String ROWNOFIELDNAME = "_rowno";
    @SerializedName(value="dsName")
    private String name;
    private String path = "client";
    private List<String> pluginList = new ArrayList<String>();
    private List<Field> fieldList = new ArrayList<Field>();
    private String genAlgorithm;
    private Strength overallStrength = Strength.pairWise;
    private List<Constraint> ruleList = new ArrayList<Constraint>();
    private List<Relation> relationList = new ArrayList<Relation>();
    private String script = "";

    public String getName() {
        return this.name;
    }

    public DataSet(String name_p) {
        this.name = name_p;
    }

    public DataSet addPlugin(String pluginID_p) {
        this.pluginList.add(pluginID_p);
        return this;
    }

    public Field addField(String name_p, String[] domainList_p) {
        Field f = new Field(name_p, Field.DataType.text, domainList_p, null, false);
        this.fieldList.add(f);
        return f;
    }

    public Field addFieldVerify(String name_p, String expr_p) {
        Field f = new Field(name_p, Field.DataType.text, new String[]{expr_p}, null, true);
        this.fieldList.add(f);
        return f;
    }

    public Field addField(String name_p, Field.DataType dataType_p, String[] domainList_p, String coupledField_p, boolean derived_p) {
        Field f = new Field(name_p, dataType_p, domainList_p, coupledField_p, derived_p);
        this.fieldList.add(f);
        return f;
    }

    public Relation addRelation(String name_p, String[] fieldNameList_p, Strength strength_p) {
        Relation r = new Relation(name_p, fieldNameList_p, strength_p);
        this.relationList.add(r);
        return r;
    }

    public Constraint addConstraint(String ifExpr_p, String thenExpr_p) throws Exception {
        if (ifExpr_p.indexOf("'") >= 0 || thenExpr_p.indexOf("'") >= 0) {
            throw new Exception("Boolean expression may not contain single quote. Enclose string literal with double quotes.");
        }
        Constraint r = new Constraint(ifExpr_p, thenExpr_p);
        this.ruleList.add(r);
        return r;
    }

    public void saveToFile(String filePath_p) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String modelJson = gson.toJson((Object)this);
        Util.writeToFile(filePath_p, modelJson);
    }

    public static DataSet fromFile(String filePath_p) throws Exception {
        StringBuffer modelJson = Util.readFile(filePath_p);
        Gson gson = new Gson();
        DataSet ds = (DataSet)gson.fromJson(modelJson.toString(), DataSet.class);
        return ds;
    }

    public static enum Strength {
        pairWise,
        threeWise,
        fourWise,
        fiveWise,
        sixWise;

    }
}

