/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole;

import beifengtz.vmconsole.entity.jcmd.JCmdEnum;
import beifengtz.vmconsole.entity.jcmd.JCmdProcess;
import beifengtz.vmconsole.entity.jcmd.JCmdResult;
import beifengtz.vmconsole.exception.NotAvailableException;
import beifengtz.vmconsole.tools.jcmd.ArgumentsTool;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.attach.HotSpotVirtualMachine;
import sun.tools.jstat.JStatLogger;

public class JCmd {
    public static JCmdResult listProcess() throws Exception {
        return JCmd.run(new String[0]);
    }

    public static JCmdResult listCommands(int vmId) throws Exception {
        return JCmd.run(new String[]{String.valueOf(vmId), "help"});
    }

    public static JCmdResult executeCommand(int vmId, JCmdEnum jCmdEnum) throws Exception {
        return JCmd.run(new String[]{String.valueOf(vmId), jCmdEnum.getCommand()});
    }

    @Deprecated
    private static JCmdResult executeCommand(int vmId, JCmdEnum ... jCmdEnum) throws Exception {
        String[] args = new String[jCmdEnum.length + 1];
        args[0] = String.valueOf(vmId);
        for (int i = 0; i < jCmdEnum.length; ++i) {
            args[i + 1] = jCmdEnum[i].getCommand();
        }
        return JCmd.run(args);
    }

    public static JCmdResult executeCommandForAllProcess(JCmdEnum jCmdEnum) throws Exception {
        return JCmd.executeCommand(0, jCmdEnum);
    }

    private static JCmdResult run(String[] var0) throws Exception {
        Iterator<VirtualMachineDescriptor> var15;
        JCmdResult jCmdResult;
        ArrayList<String> var12;
        ArgumentsTool var1;
        block20: {
            List<VirtualMachineDescriptor> var13;
            var1 = null;
            try {
                var1 = new ArgumentsTool(var0);
            }
            catch (IllegalArgumentException var10) {
                throw new IllegalArgumentException("Error parsing arguments: " + var10.getMessage());
            }
            if (var1.isShowUsage()) {
                throw new IllegalArgumentException();
            }
            if (var1.isListProcesses()) {
                JCmdResult jCmdResult2 = new JCmdResult();
                List<VirtualMachineDescriptor> var2 = VirtualMachine.list();
                for (VirtualMachineDescriptor var4 : var2) {
                    jCmdResult2.getProcesses().add(new JCmdProcess(Integer.valueOf(var4.id()), var4.displayName()));
                }
                return jCmdResult2;
            }
            var12 = new ArrayList<String>();
            jCmdResult = new JCmdResult();
            if (var1.getPid() == 0) {
                var13 = VirtualMachine.list();
                for (VirtualMachineDescriptor var5 : var13) {
                    if (JCmd.isJCmdProcess(var5)) continue;
                    var12.add(var5.id());
                }
            } else {
                if (var1.getProcessSubstring() != null) {
                    var13 = VirtualMachine.list();
                    var15 = var13.iterator();
                    while (true) {
                        VirtualMachineDescriptor var5;
                        if (!var15.hasNext()) {
                            if (var12.isEmpty()) {
                                throw new NotAvailableException("Could not find any processes matching : '" + var1.getProcessSubstring() + "'");
                            }
                            break block20;
                        }
                        var5 = var15.next();
                        if (JCmd.isJCmdProcess(var5)) continue;
                        try {
                            String var6 = JCmd.getMainClass(var5);
                            if (var6 == null || var6.indexOf(var1.getProcessSubstring()) == -1) continue;
                            var12.add(var5.id());
                        }
                        catch (URISyntaxException | MonitorException var11) {
                            if (var11.getMessage() != null) {
                                throw new Exception(var11.getMessage());
                            }
                            throw var11;
                        }
                    }
                }
                if (var1.getPid() == -1) {
                    throw new NotAvailableException("Invalid pid specified");
                }
                var12.add(var1.getPid() + "");
            }
        }
        var15 = var12.iterator();
        StringBuilder result = new StringBuilder();
        while (var15.hasNext()) {
            String var16 = (String)((Object)var15.next());
            if (var1.isListCounters()) {
                result.append(JCmd.listCounters(var16));
                continue;
            }
            result.append(JCmd.executeCommandForPid(var16, var1.getCommand()));
        }
        jCmdResult.setResult(result.toString());
        return jCmdResult;
    }

    private static String executeCommandForPid(String var0, String var1) throws AttachNotSupportedException, IOException, UnsupportedEncodingException {
        String var8;
        String[] var4;
        VirtualMachine var2 = VirtualMachine.attach(var0);
        HotSpotVirtualMachine var3 = (HotSpotVirtualMachine)var2;
        String[] var5 = var4 = var1.split("\\n");
        int var6 = var4.length;
        StringBuilder result = new StringBuilder();
        for (int var7 = 0; var7 < var6 && !(var8 = var5[var7]).trim().equals("stop"); ++var7) {
            try (InputStream var9 = var3.executeJCmd(var8);){
                int var12;
                byte[] var11 = new byte[256];
                boolean var13 = false;
                do {
                    if ((var12 = var9.read(var11)) <= 0) continue;
                    String var14 = new String(var11, 0, var12, "UTF-8");
                    result.append(var14);
                    var13 = true;
                } while (var12 > 0);
                if (var13) continue;
                result.append("Command executed successfully");
                continue;
            }
        }
        var2.detach();
        return result.toString().split("\\n{2}")[0];
    }

    private static String listCounters(String var0) throws URISyntaxException, MonitorException, IOException {
        VmIdentifier var1 = null;
        var1 = new VmIdentifier(var0);
        StringBuilder result = new StringBuilder();
        MonitoredHost var2 = MonitoredHost.getMonitoredHost(var1);
        MonitoredVm var3 = var2.getMonitoredVm(var1, -1);
        JStatLogger var4 = new JStatLogger(var3);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(outputStream);
        var4.printSnapShot("\\w*", (Comparator)new AscendingMonitorComparator(), false, true, ps);
        result.append(((Object)outputStream).toString());
        var2.detach(var3);
        ((OutputStream)outputStream).close();
        ps.close();
        return result.toString();
    }

    private static boolean isJCmdProcess(VirtualMachineDescriptor var0) {
        try {
            String var1 = JCmd.getMainClass(var0);
            return var1 != null && var1.equals(sun.tools.jcmd.JCmd.class.getName());
        }
        catch (URISyntaxException | MonitorException var2) {
            return false;
        }
    }

    private static String getMainClass(VirtualMachineDescriptor var0) throws URISyntaxException, MonitorException {
        try {
            String var1 = null;
            VmIdentifier var2 = new VmIdentifier(var0.id());
            MonitoredHost var3 = MonitoredHost.getMonitoredHost(var2);
            MonitoredVm var4 = var3.getMonitoredVm(var2, -1);
            var1 = MonitoredVmUtil.mainClass(var4, true);
            var3.detach(var4);
            return var1;
        }
        catch (NullPointerException var5) {
            return null;
        }
    }

    static class AscendingMonitorComparator
    implements Comparator<Monitor> {
        AscendingMonitorComparator() {
        }

        @Override
        public int compare(Monitor var1, Monitor var2) {
            String var3 = var1.getName();
            String var4 = var2.getName();
            return var3.compareTo(var4);
        }
    }
}

