/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole;

import beifengtz.vmconsole.entity.jinfo.JInfoFlag;
import beifengtz.vmconsole.entity.jinfo.JInfoResult;
import beifengtz.vmconsole.tools.jinfo.JInfoTool;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import sun.tools.attach.HotSpotVirtualMachine;

public class JInfoCmd {
    public static JInfoResult queryFlagsAndSysInfo(int vmId) throws Exception {
        return JInfoCmd.run(new String[]{String.valueOf(vmId)});
    }

    public static JInfoResult queryFlags(int vmId) throws Exception {
        return JInfoCmd.run(new String[]{"-flags", String.valueOf(vmId)});
    }

    public static JInfoResult querySysInfo(int vmId) throws Exception {
        return JInfoCmd.run(new String[]{"-sysprops", String.valueOf(vmId)});
    }

    public static JInfoResult queryFlag(int vmId, String flagName) throws Exception {
        return JInfoCmd.run(new String[]{"-flag", flagName, String.valueOf(vmId)});
    }

    public static JInfoResult addFlag(int vmId, String flagName) throws Exception {
        return JInfoCmd.run(new String[]{"-flag", "+" + flagName, String.valueOf(vmId)});
    }

    public static JInfoResult removeFlag(int vmId, String flagName) throws Exception {
        return JInfoCmd.run(new String[]{"-flag", "-" + flagName, String.valueOf(vmId)});
    }

    public static JInfoResult setFlag(int vmId, String flagName, String value) throws Exception {
        return JInfoCmd.run(new String[]{"-flag", flagName + "=" + value, String.valueOf(vmId)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JInfoResult run(String[] var0) throws Exception {
        if (var0.length == 0) {
            throw new IllegalArgumentException("Parameter can not be empty.");
        }
        boolean var1 = true;
        String var2 = var0[0];
        if (var2.startsWith("-")) {
            if (!var2.equals("-flags") && !var2.equals("-sysprops")) {
                if (!var2.equals("-flag")) throw new IllegalArgumentException();
                var1 = false;
            } else if (var0.length != 2 && var0.length != 3) {
                throw new IllegalArgumentException();
            }
        }
        if (var1) {
            return JInfoCmd.runTool(var0);
        }
        if (var0.length != 3) throw new IllegalArgumentException();
        String var5 = var0[2];
        String var4 = var0[1];
        return JInfoCmd.flag(var5, var4);
    }

    private static JInfoResult runTool(String[] var0) throws Exception {
        JInfoResult jInfoResult = new JInfoResult();
        JInfoTool.init(var0, jInfoResult);
        jInfoResult.setCommandType("query");
        return jInfoResult;
    }

    private static Class<?> loadClass(String var0) {
        try {
            return Class.forName(var0, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception var2) {
            return null;
        }
    }

    private static JInfoResult flag(String var0, String var1) {
        VirtualMachine var2 = JInfoCmd.attach(var0);
        int var5 = var1.indexOf(61);
        JInfoResult jInfoResult = new JInfoResult();
        try {
            InputStream var4;
            if (var5 != -1) {
                jInfoResult.setCommandType("set");
                String var3 = var1.substring(0, var5);
                String var6 = var1.substring(var5 + 1);
                var4 = ((HotSpotVirtualMachine)var2).setFlag(var3, var6);
            } else {
                char var7 = var1.charAt(0);
                switch (var7) {
                    case '+': {
                        jInfoResult.setCommandType("set");
                        String var3 = var1.substring(1);
                        var4 = ((HotSpotVirtualMachine)var2).setFlag(var3, "1");
                        break;
                    }
                    case '-': {
                        jInfoResult.setCommandType("set");
                        String var3 = var1.substring(1);
                        var4 = ((HotSpotVirtualMachine)var2).setFlag(var3, "0");
                        break;
                    }
                    default: {
                        jInfoResult.setCommandType("query");
                        var4 = ((HotSpotVirtualMachine)var2).printFlag(var1);
                    }
                }
            }
            JInfoCmd.drain(var2, var4, jInfoResult);
            jInfoResult.setSetSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            jInfoResult.setSetSuccess(false);
        }
        return jInfoResult;
    }

    private static VirtualMachine attach(String var0) {
        try {
            return VirtualMachine.attach(var0);
        }
        catch (Exception var3) {
            String var2 = var3.getMessage();
            if (var2 != null) {
                System.err.println(var0 + ": " + var2);
            } else {
                var3.printStackTrace();
            }
            System.exit(1);
            return null;
        }
    }

    private static void drain(VirtualMachine var0, InputStream var1, JInfoResult jInfoResult) throws IOException {
        int var3;
        byte[] var2 = new byte[256];
        StringBuilder res = new StringBuilder();
        do {
            if ((var3 = var1.read(var2)) <= 0) continue;
            String var4 = new String(var2, 0, var3, "UTF-8");
            res.append(var4);
        } while (var3 > 0);
        String[] content = res.toString().trim().split("\\=");
        if (content.length >= 2) {
            jInfoResult.getFlags().add(new JInfoFlag(content[0], content[1]));
        }
        var1.close();
        var0.detach();
    }
}

