/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole;

import beifengtz.vmconsole.entity.jstat.JStatResult;
import beifengtz.vmconsole.entity.jstat.JStatResultForClass;
import beifengtz.vmconsole.entity.jstat.JStatResultForCompilation;
import beifengtz.vmconsole.entity.jstat.JStatResultForCompiler;
import beifengtz.vmconsole.entity.jstat.JStatResultForGc;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcCapacity;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcMetaCapacity;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcNew;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcNewCapacity;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcOld;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcOldCapacity;
import beifengtz.vmconsole.entity.jstat.JStatResultForGcUtil;
import beifengtz.vmconsole.tools.jstat.JStatTool;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.tools.jstat.Arguments;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.OptionLister;
import sun.tools.jstat.OptionOutputFormatter;
import sun.tools.jstat.OutputFormatter;
import sun.tools.jstat.RawOutputFormatter;

public class JStatCmd {
    private static Arguments arguments;

    public static JStatResult list() throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-list"});
        if (r == null) {
            throw new NullPointerException();
        }
        return r.get(0);
    }

    public static JStatResult snap(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-snap", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        return r.get(0);
    }

    public static JStatResultForClass clazz(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-class", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForClass)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForClass> clazz(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-class", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForClass> res = new ArrayList<JStatResultForClass>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForClass)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGc gc(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gc", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGc)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGc> gc(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gc", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGc> res = new ArrayList<JStatResultForGc>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGc)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForCompiler compiler(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-compiler", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForCompiler)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForCompiler> compiler(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-compiler", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForCompiler> res = new ArrayList<JStatResultForCompiler>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForCompiler)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcCapacity gcCapacity(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gccapacity", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcCapacity)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcCapacity> gcCapacity(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gccapacity", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcCapacity> res = new ArrayList<JStatResultForGcCapacity>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcCapacity)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcNew gcNew(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcnew", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcNew)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcNew> gcNew(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcnew", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcNew> res = new ArrayList<JStatResultForGcNew>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcNew)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcNewCapacity gcNewCapacity(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcnewcapacity", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcNewCapacity)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcNewCapacity> gcNewCapacity(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcnewcapacity", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcNewCapacity> res = new ArrayList<JStatResultForGcNewCapacity>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcNewCapacity)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcOld gcOld(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcold", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcOld)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcOld> gcOld(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcold", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcOld> res = new ArrayList<JStatResultForGcOld>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcOld)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcOldCapacity gcOldCapacity(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcoldcapacity", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcOldCapacity)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcOldCapacity> gcOldCapacitiy(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcoldcapacity", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcOldCapacity> res = new ArrayList<JStatResultForGcOldCapacity>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcOldCapacity)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcMetaCapacity gcMetaCapacity(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcmetacapacity", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcMetaCapacity)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcMetaCapacity> gcMetaCapacitiy(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcmetacapacity", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcMetaCapacity> res = new ArrayList<JStatResultForGcMetaCapacity>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcMetaCapacity)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForGcUtil gcUtil(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcutil", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForGcUtil)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForGcUtil> gcUtil(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-gcutil", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForGcUtil> res = new ArrayList<JStatResultForGcUtil>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForGcUtil)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static JStatResultForCompilation printCompilation(int vmId) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-printcompilation", String.valueOf(vmId)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            return (JStatResultForCompilation)r.get(0);
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResultForCompilation> printCompilation(int vmId, long interval, int count) throws IllegalArgumentException, NullPointerException {
        ArrayList<JStatResult> r = JStatCmd.run(new String[]{"-printcompilation", String.valueOf(vmId), String.valueOf(interval), String.valueOf(count)});
        if (r == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<JStatResultForCompilation> res = new ArrayList<JStatResultForCompilation>(count);
            for (JStatResult j : r) {
                res.add((JStatResultForCompilation)j);
            }
            return res;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new NullPointerException();
        }
    }

    public static ArrayList<JStatResult> run(String[] var0) throws IllegalArgumentException {
        arguments = new Arguments(var0);
        if (arguments.isHelp()) {
            Arguments.printUsage((PrintStream)System.out);
            arguments = null;
            return null;
        }
        if (arguments.isOptions()) {
            OptionLister var1 = new OptionLister(arguments.optionsSources());
            var1.print(System.out);
            arguments = null;
            return null;
        }
        ArrayList<JStatResult> jStatResults = null;
        try {
            jStatResults = arguments.isList() ? JStatCmd.names() : (arguments.isSnap() ? JStatCmd.snapShot() : JStatCmd.samples());
        }
        catch (MonitorException var4) {
            if (var4.getMessage() != null) {
                System.err.println(var4.getMessage());
            }
            Throwable var2 = var4.getCause();
            if (var2 != null && var2.getMessage() != null) {
                System.err.println(var2.getMessage());
            }
            var4.printStackTrace();
        }
        return jStatResults;
    }

    static ArrayList<JStatResult> names() throws MonitorException {
        VmIdentifier var0 = arguments.vmId();
        int var1 = arguments.sampleInterval();
        MonitoredHost var2 = MonitoredHost.getMonitoredHost(var0);
        MonitoredVm var3 = null;
        try {
            var3 = var2.getMonitoredVm(var0, var1);
        }
        catch (MonitorException e) {
            e.printStackTrace();
        }
        JStatTool var4 = new JStatTool(var3);
        ArrayList<JStatResult> resList = new ArrayList<JStatResult>(1);
        JStatResult jStatResult = new JStatResult();
        jStatResult.setVmId(var0.getLocalVmId());
        resList.add(jStatResult);
        var4.printNames(arguments.counterNames(), arguments.comparator(), arguments.showUnsupported(), System.out, resList);
        var2.detach(var3);
        return resList;
    }

    static ArrayList<JStatResult> snapShot() throws MonitorException {
        VmIdentifier var0 = arguments.vmId();
        int var1 = arguments.sampleInterval();
        MonitoredHost var2 = MonitoredHost.getMonitoredHost(var0);
        MonitoredVm var3 = var2.getMonitoredVm(var0, var1);
        JStatTool var4 = new JStatTool(var3);
        ArrayList<JStatResult> resList = new ArrayList<JStatResult>(1);
        JStatResult jStatResult = new JStatResult();
        jStatResult.setVmId(var0.getLocalVmId());
        resList.add(jStatResult);
        var4.printSnapShot(arguments.counterNames(), arguments.comparator(), arguments.isVerbose(), arguments.showUnsupported(), System.out, resList);
        var2.detach(var3);
        return resList;
    }

    static ArrayList<JStatResult> samples() throws MonitorException {
        final VmIdentifier var0 = arguments.vmId();
        int var1 = arguments.sampleInterval();
        final MonitoredHost var2 = MonitoredHost.getMonitoredHost(var0);
        MonitoredVm var3 = var2.getMonitoredVm(var0, var1);
        final JStatTool var4 = new JStatTool(var3);
        OptionOutputFormatter var5 = null;
        if (arguments.isSpecialOption()) {
            OptionFormat var6 = arguments.optionFormat();
            var5 = new OptionOutputFormatter(var3, var6);
        } else {
            List<Monitor> var10 = var3.findByPattern(arguments.counterNames());
            Collections.sort(var10, arguments.comparator());
            ArrayList<Monitor> var7 = new ArrayList<Monitor>();
            Iterator<Monitor> var8 = var10.iterator();
            while (var8.hasNext()) {
                Monitor var9 = var8.next();
                if (!var9.isSupported() && !arguments.showUnsupported()) {
                    var8.remove();
                    continue;
                }
                if (var9.getVariability() == Variability.CONSTANT) {
                    var8.remove();
                    if (!arguments.printConstants()) continue;
                    var7.add(var9);
                    continue;
                }
                if (var9.getUnits() != Units.STRING || arguments.printStrings()) continue;
                var8.remove();
            }
            if (!var7.isEmpty()) {
                var4.printList(var7, arguments.isVerbose(), arguments.showUnsupported(), System.out);
                if (!var10.isEmpty()) {
                    System.out.println();
                }
            }
            if (var10.isEmpty()) {
                var2.detach(var3);
                return null;
            }
            var5 = new RawOutputFormatter(var10, arguments.printStrings());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                var4.stopLogging();
            }
        });
        HostListener var11 = new HostListener(){

            @Override
            public void vmStatusChanged(VmStatusChangeEvent var1) {
                Integer var2x = new Integer(var0.getLocalVmId());
                if (var1.getTerminated().contains(var2x)) {
                    var4.stopLogging();
                } else if (!var1.getActive().contains(var2x)) {
                    var4.stopLogging();
                }
            }

            @Override
            public void disconnected(HostEvent var1) {
                if (var2 == var1.getMonitoredHost()) {
                    var4.stopLogging();
                }
            }
        };
        if (var0.getLocalVmId() != 0) {
            var2.addHostListener(var11);
        }
        ArrayList<JStatResult> resList = new ArrayList<JStatResult>(arguments.sampleCount());
        var4.logSamples((OutputFormatter)var5, arguments.headerRate(), arguments.sampleInterval(), arguments.sampleCount(), System.out, var0.getLocalVmId(), arguments.specialOption(), resList);
        if (var11 != null) {
            var2.removeHostListener(var11);
        }
        var2.detach(var3);
        return resList;
    }
}

