/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole;

import beifengtz.vmconsole.entity.jps.JpsResult;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jps.Arguments;

public class JpsCmd {
    private static Arguments arguments;

    public static List<JpsResult> quit() throws IllegalArgumentException, MonitorException {
        return JpsCmd.run(new String[]{"-q"});
    }

    public static List<JpsResult> withMainClassArgs() throws IllegalArgumentException, MonitorException {
        return JpsCmd.run(new String[]{"-m"});
    }

    public static List<JpsResult> withFullName() throws IllegalArgumentException, MonitorException {
        return JpsCmd.run(new String[]{"-l"});
    }

    public static List<JpsResult> withVmArgs() throws IllegalArgumentException, MonitorException {
        return JpsCmd.run(new String[]{"-v"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JpsResult> run(String[] var0) throws IllegalArgumentException, MonitorException {
        arguments = new Arguments(var0);
        if (arguments.isHelp()) {
            Arguments.printUsage((PrintStream)System.err);
            arguments = null;
            return null;
        }
        ArrayList<JpsResult> jpsResultList = new ArrayList<JpsResult>();
        HostIdentifier var1 = arguments.hostId();
        MonitoredHost var25 = MonitoredHost.getMonitoredHost(var1);
        Set<Integer> var3 = var25.activeVms();
        Iterator<Integer> var4 = var3.iterator();
        while (var4.hasNext()) {
            JpsResult jpsResult;
            block19: {
                jpsResult = new JpsResult();
                ArrayList<Object> errStacks = new ArrayList<Object>();
                Integer var5 = var4.next();
                jpsResult.setVmId(var5);
                StringBuilder var6 = new StringBuilder();
                Exception var7 = null;
                int var8 = var5;
                var6.append(String.valueOf(var8));
                if (arguments.isQuiet()) {
                    jpsResult.setStrResult(String.valueOf(var6));
                } else {
                    MonitoredVm var9 = null;
                    String var10 = "//" + var8 + "?mode=r";
                    String var11 = null;
                    try {
                        String var13;
                        var11 = " -- process information unavailable";
                        VmIdentifier var12 = new VmIdentifier(var10);
                        var9 = var25.getMonitoredVm(var12, 0);
                        var11 = " -- main class information unavailable";
                        var6.append(" ");
                        var6.append(MonitoredVmUtil.mainClass(var9, arguments.showLongPaths()));
                        jpsResult.setMainClass(MonitoredVmUtil.mainClass(var9, arguments.showLongPaths()));
                        if (arguments.showMainArgs()) {
                            var11 = " -- main args information unavailable";
                            var13 = MonitoredVmUtil.mainArgs(var9);
                            if (var13 != null && var13.length() > 0) {
                                var6.append(" ");
                                var6.append(var13);
                                jpsResult.setMainArgs(var13);
                            }
                        }
                        if (arguments.showVmArgs()) {
                            var11 = " -- beifengtz args information unavailable";
                            var13 = MonitoredVmUtil.jvmArgs(var9);
                            if (var13 != null && var13.length() > 0) {
                                var6.append(" ");
                                var6.append(var13);
                                jpsResult.setVmArgs(var13);
                            }
                        }
                        if (arguments.showVmFlags()) {
                            var11 = " -- beifengtz flags information unavailable";
                            var13 = MonitoredVmUtil.jvmFlags(var9);
                            if (var13 != null && var13.length() > 0) {
                                var6.append(" ");
                                var6.append(var13);
                                jpsResult.setVmFlags(var13);
                            }
                        }
                        var11 = " -- detach failed";
                        var25.detach(var9);
                        jpsResult.setStrResult(String.valueOf(var6));
                        var11 = null;
                    }
                    catch (URISyntaxException var21) {
                        var7 = var21;
                        errStacks.add(var21);
                        assert (false);
                    }
                    catch (Exception var22) {
                        var7 = var22;
                        errStacks.add(var22);
                    }
                    finally {
                        if (var11 == null) break block19;
                        var6.append(var11);
                        jpsResult.setErrMessage(var11);
                        jpsResult.setErrStacks(errStacks);
                        errStacks = null;
                        if (arguments.isDebug() && var7 != null && ((Throwable)var7).getMessage() != null) {
                            var6.append("\n\t");
                            var6.append(((Throwable)var7).getMessage());
                        }
                        jpsResult.setStrResult(String.valueOf(var6));
                        if (!arguments.printStackTrace()) continue;
                        ((Throwable)var7).printStackTrace();
                        continue;
                    }
                }
            }
            jpsResultList.add(jpsResult);
            jpsResult = null;
        }
        arguments = null;
        return jpsResultList;
    }
}

