/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole.tools.jinfo;

import beifengtz.vmconsole.entity.jinfo.JInfoFlag;
import beifengtz.vmconsole.entity.jinfo.JInfoResult;
import beifengtz.vmconsole.exception.NotAvailableException;
import beifengtz.vmconsole.exception.UnInitException;
import beifengtz.vmconsole.tools.MyTool;
import beifengtz.vmconsole.tools.jinfo.SysPropsDumperTool;
import java.io.PrintStream;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.Arguments;
import sun.jvm.hotspot.runtime.VM;

public class JInfoTool
extends MyTool {
    public static final int MODE_FLAGS = 0;
    public static final int MODE_SYSPROPS = 1;
    public static final int MODE_BOTH = 2;
    private int mode;
    private static boolean hasInit;
    private PrintStream ps;
    private JInfoResult jInfoResult;

    public JInfoTool() {
    }

    public JInfoTool(int m) {
        this(m, System.out);
    }

    public JInfoTool(int m, PrintStream ps) {
        this.mode = m;
        this.ps = ps;
        hasInit = true;
    }

    public JInfoTool(int m, JInfoResult jInfoResult) {
        this.mode = m;
        this.jInfoResult = jInfoResult;
        hasInit = true;
    }

    public JInfoTool(JVMDebugger d) {
        super(d);
    }

    @Override
    public boolean needsJavaPrefix() {
        return false;
    }

    @Override
    public String getName() {
        return "jinfo";
    }

    @Override
    protected void printFlagsUsage() {
        System.out.println("    -flags\tto print VM flags");
        System.out.println("    -sysprops\tto print Java System properties");
        System.out.println("    <no option>\tto print both of the above");
        super.printFlagsUsage();
    }

    @Override
    public void run() {
        if (hasInit) {
            MyTool tool = null;
            try {
                switch (this.mode) {
                    case 0: {
                        this.printVMFlags(this.jInfoResult);
                        return;
                    }
                    case 1: {
                        tool = new SysPropsDumperTool();
                        tool.setAgent(this.getAgent());
                        ((SysPropsDumperTool)tool).run(this.jInfoResult);
                        break;
                    }
                    case 2: {
                        tool = new MyTool(){

                            @Override
                            public void run() {
                                SysPropsDumperTool sysProps = new SysPropsDumperTool();
                                sysProps.setAgent(this.getAgent());
                                try {
                                    sysProps.run(JInfoTool.this.jInfoResult);
                                }
                                catch (NotAvailableException e) {
                                    e.printStackTrace();
                                }
                                JInfoTool.this.printVMFlags(JInfoTool.this.jInfoResult);
                            }
                        };
                        tool.run();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (NotAvailableException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else {
            try {
                JInfoTool.throwInitException();
            }
            catch (UnInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static void throwInitException() throws UnInitException {
        throw new UnInitException("JStackTool have not initialized. The caller should call the init method first.");
    }

    public static void init(String[] args) throws Exception {
        JInfoTool.init(args, System.out);
    }

    public static void init(String[] args, PrintStream ps) throws Exception {
        ToolArg toolArg = JInfoTool.initDoFirst(args);
        JInfoTool jinfo = new JInfoTool(toolArg.mode, ps);
        jinfo.execute(toolArg.args, ps);
    }

    public static void init(String[] args, JInfoResult jInfoResult) throws Exception {
        ToolArg toolArg = JInfoTool.initDoFirst(args);
        JInfoTool jinfo = new JInfoTool(toolArg.mode, jInfoResult);
        jinfo.execute(toolArg.args, jInfoResult);
    }

    private static ToolArg initDoFirst(String[] args) {
        int mode = -1;
        switch (args.length) {
            case 1: {
                if (args[0].charAt(0) == '-') {
                    throw new IllegalArgumentException();
                }
                mode = 2;
                break;
            }
            case 2: 
            case 3: {
                String modeFlag = args[0];
                if (modeFlag.equals("-flags")) {
                    mode = 0;
                } else if (modeFlag.equals("-sysprops")) {
                    mode = 1;
                } else {
                    if (modeFlag.charAt(0) == '-') {
                        throw new IllegalArgumentException();
                    }
                    mode = 2;
                }
                if (mode == 2) break;
                String[] newArgs = new String[args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = args[i + 1];
                }
                args = newArgs;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new ToolArg(mode, args);
    }

    private void printVMFlags(PrintStream out) {
        VM.Flag[] flags = VM.getVM().getCommandLineFlags();
        out.print("Non-default VM flags: ");
        VM.Flag[] arr$ = flags;
        int len$ = flags.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            VM.Flag flag = arr$[i$];
            if (flag.getOrigin() == 0) continue;
            if (flag.isBool()) {
                String onoff = flag.getBool() ? "+" : "-";
                out.print("-XX:" + onoff + flag.getName() + " ");
                continue;
            }
            out.print("-XX:" + flag.getName() + "=" + flag.getValue() + " ");
        }
        out.println();
        out.print("Command line: ");
        String str = Arguments.getJVMFlags();
        if (str != null) {
            System.out.print(str + " ");
        }
        if ((str = Arguments.getJVMArgs()) != null) {
            System.out.print(str);
        }
        out.println();
    }

    private void printVMFlags(JInfoResult jInfoResult) {
        VM.Flag[] flags;
        VM.Flag[] arr$ = flags = VM.getVM().getCommandLineFlags();
        int len$ = flags.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            VM.Flag flag = arr$[i$];
            if (flag.getOrigin() == 0) continue;
            JInfoFlag jInfoFlag = null;
            if (flag.isBool()) {
                String onoff = flag.getBool() ? "+" : "-";
                jInfoFlag = new JInfoFlag("-XX:" + onoff + flag.getName(), null);
            } else {
                jInfoFlag = new JInfoFlag("-XX:" + flag.getName(), flag.getValue());
            }
            jInfoResult.getFlags().add(jInfoFlag);
        }
        String str = Arguments.getJVMFlags();
        StringBuilder commandLine = new StringBuilder();
        if (str != null) {
            commandLine.append(str);
            commandLine.append(" ");
        }
        if ((str = Arguments.getJVMArgs()) != null) {
            commandLine.append(str);
        }
        jInfoResult.setCommandLine(commandLine.toString());
        commandLine = null;
    }

    static class ToolArg {
        int mode;
        String[] args;

        public ToolArg(int mode, String[] args) {
            this.mode = mode;
            this.args = args;
        }
    }
}

