/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole.tools.jinfo;

import beifengtz.vmconsole.entity.jinfo.JInfoNode;
import beifengtz.vmconsole.entity.jinfo.JInfoResult;
import beifengtz.vmconsole.exception.NotAvailableException;
import beifengtz.vmconsole.tools.MyTool;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.VM;

public class SysPropsDumperTool
extends MyTool {
    public SysPropsDumperTool() {
    }

    public SysPropsDumperTool(JVMDebugger d) {
        super(d);
    }

    @Override
    public void run() {
        this.run(System.out);
    }

    public void run(PrintStream out) {
        Properties sysProps = VM.getVM().getSystemProperties();
        if (sysProps != null) {
            Enumeration<Object> keys = sysProps.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                out.print(key);
                out.print(" = ");
                out.println(sysProps.get(key));
            }
        } else {
            out.println("System Properties info not available!");
        }
    }

    public void run(JInfoResult jInfoResult) throws NotAvailableException {
        Properties sysProps = VM.getVM().getSystemProperties();
        if (sysProps != null) {
            Enumeration<Object> keys = sysProps.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                jInfoResult.getInfoList().add(new JInfoNode(key.toString(), sysProps.get(key).toString()));
            }
        } else {
            throw new NotAvailableException("System Properties info not available!");
        }
    }
}

