/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole.tools.jstack;

import beifengtz.vmconsole.entity.jstack.JStackResult;
import beifengtz.vmconsole.entity.jstack.ThreadStack;
import beifengtz.vmconsole.exception.UnKnowException;
import beifengtz.vmconsole.tools.MyTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.ConcurrentLocksPrinter;
import sun.jvm.hotspot.runtime.DeadlockDetector;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;

public class StackTraceTool
extends MyTool {
    private boolean verbose;
    private boolean concurrentLocks;

    public StackTraceTool(boolean v, boolean concurrentLocks) {
        this.verbose = v;
        this.concurrentLocks = concurrentLocks;
    }

    public StackTraceTool() {
        this(true, true);
    }

    @Override
    public void run() {
        this.run(System.out);
    }

    public StackTraceTool(JVMDebugger d) {
        super(d);
    }

    public StackTraceTool(JVMDebugger d, boolean v, boolean concurrentLocks) {
        super(d);
        this.verbose = v;
        this.concurrentLocks = concurrentLocks;
    }

    public void run(PrintStream tty) {
        try {
            DeadlockDetector.print((PrintStream)tty);
        }
        catch (Exception var11) {
            var11.printStackTrace();
            tty.println("Can't print deadlocks:" + var11.getMessage());
        }
        try {
            ConcurrentLocksPrinter concLocksPrinter = null;
            if (this.concurrentLocks) {
                concLocksPrinter = new ConcurrentLocksPrinter();
            }
            Threads threads = VM.getVM().getThreads();
            int i = 1;
            JavaThread cur = threads.first();
            while (cur != null) {
                if (cur.isJavaThread()) {
                    Address sp = cur.getLastJavaSP();
                    tty.print("Thread ");
                    cur.printThreadIDOn(tty);
                    tty.print(": (state = " + cur.getThreadState());
                    if (this.verbose) {
                        tty.println(", current Java SP = " + sp);
                    }
                    tty.println(')');
                    try {
                        for (JavaVFrame vf = cur.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                            Method method = vf.getMethod();
                            tty.print(" - " + method.externalNameAndSignature() + " @bci=" + vf.getBCI());
                            int lineNumber = method.getLineNumberFromBCI(vf.getBCI());
                            if (lineNumber != -1) {
                                tty.print(", line=" + lineNumber);
                            }
                            if (this.verbose) {
                                Address pc = vf.getFrame().getPC();
                                if (pc != null) {
                                    tty.print(", pc=" + pc);
                                }
                                tty.print(", Method*=" + method.getAddress());
                            }
                            if (vf.isCompiledFrame()) {
                                tty.print(" (Compiled frame");
                                if (vf.isDeoptimized()) {
                                    tty.print(" [deoptimized]");
                                }
                            }
                            if (vf.isInterpretedFrame()) {
                                tty.print(" (Interpreted frame");
                            }
                            if (vf.mayBeImpreciseDbg()) {
                                tty.print("; information may be imprecise");
                            }
                            tty.println(")");
                        }
                    }
                    catch (Exception var12) {
                        tty.println("Error occurred during stack walking:");
                        var12.printStackTrace();
                    }
                    tty.println();
                    if (this.concurrentLocks) {
                        concLocksPrinter.print(cur, tty);
                    }
                    tty.println();
                }
                cur = cur.next();
                ++i;
            }
        }
        catch (AddressException var13) {
            System.err.println("Error accessing address 0x" + Long.toHexString(var13.getAddress()));
            var13.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JStackResult jStackResult) throws IOException, UnKnowException, AddressException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        PrintStream tty = new PrintStream(outputStream);
        try {
            DeadlockDetector.print((PrintStream)tty);
        }
        catch (Exception var11) {
            jStackResult.setDeadlocks("ERROR! Can't print deadlocks:" + var11.getMessage());
            this.closeStream(tty, outputStream);
            throw new UnKnowException(var11.getMessage());
        }
        try {
            ConcurrentLocksPrinter concLocksPrinter = null;
            if (this.concurrentLocks) {
                concLocksPrinter = new ConcurrentLocksPrinter();
            }
            Threads threads = VM.getVM().getThreads();
            int i = 1;
            LinkedList<ThreadStack> threadStacks = new LinkedList<ThreadStack>();
            JavaThread cur = threads.first();
            while (cur != null) {
                ThreadStack threadStack = new ThreadStack();
                if (cur.isJavaThread()) {
                    Address sp = cur.getLastJavaSP();
                    cur.printThreadIDOn(tty);
                    String idInfo = outputStream.toString().trim();
                    if (i == 1) {
                        String[] strs = idInfo.split("\\n");
                        String threadId = strs[strs.length - 1];
                        threadStack.setDeadLocks(idInfo.substring(0, idInfo.length() - threadId.length() - 1));
                        threadStack.setId(threadId);
                    } else {
                        threadStack.setId(idInfo);
                    }
                    outputStream.reset();
                    threadStack.setState(cur.getThreadState().toString());
                    if (this.verbose) {
                        threadStack.setCurrentJavaSP(sp.toString());
                    }
                    StringBuilder tempStacks = new StringBuilder();
                    try {
                        for (JavaVFrame vf = cur.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                            Method method = vf.getMethod();
                            tempStacks.append(" - ");
                            tempStacks.append(method.externalNameAndSignature());
                            tempStacks.append(" @bci=");
                            tempStacks.append(vf.getBCI());
                            int lineNumber = method.getLineNumberFromBCI(vf.getBCI());
                            if (lineNumber != -1) {
                                tempStacks.append(", line=");
                                tempStacks.append(lineNumber);
                            }
                            if (this.verbose) {
                                Address pc = vf.getFrame().getPC();
                                if (pc != null) {
                                    tempStacks.append(", pc=");
                                    tempStacks.append(pc);
                                }
                                tempStacks.append(", Method*=");
                                tempStacks.append(method.getAddress());
                            }
                            if (vf.isCompiledFrame()) {
                                tempStacks.append(" (Compiled frame");
                                if (vf.isDeoptimized()) {
                                    tempStacks.append(" [deoptimized]");
                                }
                            }
                            if (vf.isInterpretedFrame()) {
                                tempStacks.append(" (Interpreted frame");
                            }
                            if (vf.mayBeImpreciseDbg()) {
                                tempStacks.append("; information may be imprecise");
                            }
                            tempStacks.append(")");
                            tempStacks.append("\n");
                        }
                    }
                    catch (Exception var12) {
                        tempStacks.append("Error occurred during stack walking:");
                        tempStacks.append(var12.getMessage());
                    }
                    finally {
                        threadStack.setStacks(tempStacks);
                    }
                    if (this.concurrentLocks) {
                        concLocksPrinter.print(cur, tty);
                        threadStack.setConcurrentLocks(outputStream.toString());
                        outputStream.reset();
                    }
                    threadStacks.add(threadStack);
                }
                cur = cur.next();
                ++i;
            }
            jStackResult.setThreadStacks(threadStacks);
        }
        catch (AddressException var13) {
            System.err.println("Error accessing address 0x" + Long.toHexString(var13.getAddress()));
            throw var13;
        }
    }

    private void closeStream(PrintStream ps, OutputStream o) throws IOException {
        ps.close();
        o.close();
    }
}

