/*
 * Decompiled with CFR 0.152.
 */
package beifengtz.vmconsole.tools.jstat;

import beifengtz.vmconsole.entity.jstat.JStatResult;
import beifengtz.vmconsole.tools.jstat.JStatResultTool;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;
import sun.tools.jstat.OutputFormatter;

public class JStatTool {
    private MonitoredVm monitoredVm;
    private volatile boolean active = true;

    public JStatTool(MonitoredVm var1) {
        this.monitoredVm = var1;
    }

    public void printNames(String var1, Comparator<Monitor> var2, boolean var3, PrintStream var4, ArrayList<JStatResult> resList) throws MonitorException, PatternSyntaxException {
        List<Monitor> var5 = this.monitoredVm.findByPattern(var1);
        Collections.sort(var5, var2);
        Iterator<Monitor> var6 = var5.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (var6.hasNext()) {
            Monitor var7 = var6.next();
            if (!var7.isSupported() && !var3) continue;
            list.add(var7.getName());
            resList.get(0).setNames(list);
        }
        return;
    }

    public void printSnapShot(String var1, Comparator<Monitor> var2, boolean var3, boolean var4, PrintStream var5, ArrayList<JStatResult> resList) throws MonitorException, PatternSyntaxException {
        List<Monitor> var6 = this.monitoredVm.findByPattern(var1);
        Collections.sort(var6, var2);
        this.printListWithReturn(var6, var3, var4, var5, resList);
    }

    public void printListWithReturn(List<Monitor> var1, boolean var2, boolean var3, PrintStream var4, ArrayList<JStatResult> resList) throws MonitorException {
        Iterator<Monitor> var5 = var1.iterator();
        ArrayList<String> snap = new ArrayList<String>();
        while (var5.hasNext()) {
            Monitor var6 = var5.next();
            if (!var6.isSupported() && !var3) continue;
            StringBuilder var7 = new StringBuilder();
            var7.append(var6.getName()).append("=");
            if (var6 instanceof StringMonitor) {
                var7.append("\"").append(var6.getValue()).append("\"");
            } else {
                var7.append(var6.getValue());
            }
            if (var2) {
                var7.append(" ").append(var6.getUnits());
                var7.append(" ").append(var6.getVariability());
                var7.append(" ").append(var6.isSupported() ? "Supported" : "Unsupported");
            }
            snap.add(var7.toString());
            resList.get(0).setSnapShot(snap);
        }
        return;
    }

    public void printList(List<Monitor> var1, boolean var2, boolean var3, PrintStream var4) throws MonitorException {
        Iterator<Monitor> var5 = var1.iterator();
        while (var5.hasNext()) {
            Monitor var6 = var5.next();
            if (!var6.isSupported() && !var3) continue;
            StringBuilder var7 = new StringBuilder();
            var7.append(var6.getName()).append("=");
            if (var6 instanceof StringMonitor) {
                var7.append("\"").append(var6.getValue()).append("\"");
            } else {
                var7.append(var6.getValue());
            }
            if (var2) {
                var7.append(" ").append(var6.getUnits());
                var7.append(" ").append(var6.getVariability());
                var7.append(" ").append(var6.isSupported() ? "Supported" : "Unsupported");
            }
            var4.println(var7);
        }
        return;
    }

    public void stopLogging() {
        this.active = false;
    }

    public void logSamples(OutputFormatter var1, int var2, int var3, int var4, PrintStream var5, int vmId, String option, ArrayList<JStatResult> resList) throws MonitorException {
        long var6 = 0L;
        int var8 = 0;
        int var9 = var2;
        if (var2 == 0) {
            var9 = -1;
        }
        while (this.active) {
            if (var9 > 0 && --var8 <= 0) {
                var8 = var9;
            }
            JStatResult jStatResult = JStatResultTool.getJStatResult(option, var1.getRow());
            jStatResult.setVmId(vmId);
            jStatResult.setStrResult(var1.getRow());
            resList.add(jStatResult);
            if (var4 > 0 && ++var6 >= (long)var4) break;
            try {
                Thread.sleep(var3);
            }
            catch (Exception exception) {}
        }
    }
}

