/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore;

import com.github.vatbub.common.core.Common;
import com.github.vatbub.safeAPIKeyStore.SafeAPIKeyStoreTestBase;
import com.github.vatbub.safeAPIKeyStore.server.Main;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.SystemErrRule;
import org.junit.contrib.java.lang.system.SystemOutRule;

public class MainTest {
    @Rule
    public final SystemOutRule systemOutRule = new SystemOutRule().enableLog();
    public final SystemErrRule systemErrRule = new SystemErrRule().enableLog();

    @BeforeClass
    public static void oneTimeSetUp() {
        Common.getInstance().setAppName("SafeAPIKeyStoreServerTests");
    }

    @Test
    public void mainInstantiationTest() {
        try {
            Constructor constructor = Main.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void printHelpTest() {
        Main.printHelpMessage((Options)Main.createCommandlineOptions());
        Assert.assertFalse((boolean)this.systemOutRule.getLog().isEmpty());
    }

    @Test
    public void noArgTest() {
        Main.main((String[])new String[0]);
        Assert.assertTrue((boolean)this.systemOutRule.getLog().contains("usage"));
        Main.getServer().stop();
    }

    @Test
    public void portOnlyTest() {
        String[] args = new String[]{"-p", "8080"};
        Main.main((String[])args);
        Assert.assertTrue((boolean)this.systemOutRule.getLog().contains("usage"));
    }

    @Test
    public void expandedPortOnlyTest() {
        String[] args = new String[]{"--port", "8080"};
        Main.main((String[])args);
        Assert.assertTrue((boolean)this.systemOutRule.getLog().contains("usage"));
    }

    @Test
    public void apiKeyFileOnlyTest() throws IOException {
        File apiKeyFile = SafeAPIKeyStoreTestBase.createApiKeyFile();
        String[] args = new String[]{"-apiKeyFile", apiKeyFile.getAbsolutePath()};
        Main.main((String[])args);
        Assert.assertFalse((boolean)this.systemOutRule.getLog().contains("usage"));
    }

    @Test
    public void allArgsTest() throws IOException {
        File apiKeyFile = SafeAPIKeyStoreTestBase.createApiKeyFile();
        String[] args = new String[]{"-p", "8080", "-apiKeyFile", apiKeyFile.getAbsolutePath()};
        Main.main((String[])args);
        Assert.assertFalse((boolean)this.systemOutRule.getLog().contains("usage"));
    }

    @Test
    public void illegalApiKeyFileTest() {
        String[] args = new String[]{"-p", "8080", "-apiKeyFile", "notExistingDummyFile.properties"};
        Main.main((String[])args);
        Assert.assertFalse((boolean)this.systemErrRule.getLog().contains("Could not launch the server"));
    }
}

