/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore.server;

import com.github.vatbub.common.core.Common;
import com.github.vatbub.common.core.logging.FOKLogger;
import com.github.vatbub.safeAPIKeyStore.server.Server;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static Server server;
    private static Options optionsCache;
    private static Option portOptionCache;
    private static Option apiKeyFileOptionCache;

    private Main() {
        throw new IllegalStateException("Class may not be instantiated");
    }

    public static void main(String[] args) {
        Common.getInstance().setAppName("com.github.vatbub.safeAPIKeyStore.server");
        Options cliOptions = Main.createCommandlineOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(cliOptions, args);
            int port = Integer.parseInt(commandLine.getOptionValue(Main.createPortOption().getOpt(), "1650"));
            String apiKeyFile = commandLine.getOptionValue(Main.createApiKeyFileOption().getOpt());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (server != null) {
                    server.stop();
                }
            }));
            server = new Server(port, apiKeyFile);
        }
        catch (ParseException e) {
            Main.printHelpMessage(cliOptions);
        }
        catch (IOException e) {
            FOKLogger.log((String)Main.class.getName(), (Level)Level.SEVERE, (String)"Could not launch the server", (Throwable)e);
        }
    }

    public static Server getServer() {
        return server;
    }

    public static Options createCommandlineOptions() {
        if (optionsCache == null) {
            optionsCache = new Options();
            optionsCache.addOption(Main.createPortOption());
            optionsCache.addOption(Main.createApiKeyFileOption());
        }
        return optionsCache;
    }

    public static Option createPortOption() {
        if (portOptionCache == null) {
            portOptionCache = new Option("p", "port", true, "The port to run the server on");
            portOptionCache.setRequired(false);
            portOptionCache.setType(Integer.class);
        }
        return portOptionCache;
    }

    public static Option createApiKeyFileOption() {
        if (apiKeyFileOptionCache == null) {
            apiKeyFileOptionCache = new Option("apiKeyFile", true, "The path to the file that contains all api keys to be served (required)");
            apiKeyFileOptionCache.setRequired(true);
            apiKeyFileOptionCache.setType(String.class);
        }
        return apiKeyFileOptionCache;
    }

    public static void printHelpMessage(Options cliOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Common.getInstance().getPathAndNameOfCurrentJar(), cliOptions);
    }
}

