/*
 * Decompiled with CFR 0.152.
 */
package com.wei.springboot.starter.code.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.StringUtility;

@Mojo(name="generator", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class CodeGeneratorMojo
extends AbstractMojo {
    private static final String targetProject = "src\\main\\java";
    private static final String targetResources = "src\\main\\resources";
    private static final String all = "all";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/generatorConfig.xml")
    private File configurationFile;
    @Parameter(defaultValue="true")
    private boolean overwrite;
    @Parameter(property="jdbcDriver")
    private String jdbcDriver;
    @Parameter(property="jdbcURL")
    private String jdbcURL;
    @Parameter(property="jdbcUserId")
    private String jdbcUserId;
    @Parameter(property="jdbcPassword")
    private String jdbcPassword;
    @Parameter(property="tableNames", defaultValue="all")
    private String tableNames;
    @Parameter(property="xMapper")
    private String xMapper;
    @Parameter(property="basePackage")
    private String basePackage;
    @Parameter(property="noXml", defaultValue="true")
    private boolean noXml;
    @Parameter(property="generatorModle", defaultValue="base")
    private String generatorModle;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ArrayList warnings = new ArrayList();
            Configuration config = new Configuration();
            if (this.configurationFile != null && this.configurationFile.exists()) {
                ConfigurationParser cp = new ConfigurationParser(warnings);
                config = cp.parseConfiguration(this.configurationFile);
            } else {
                Context context = new Context(ModelType.FLAT);
                context.setId("code-generator");
                context.setTargetRuntime("MyBatis3");
                this.addPluginConfigurationToContext(context);
                if (all.equals(this.generatorModle)) {
                    this.addServicePluginConfigurationToContext(context);
                }
                context.setCommentGeneratorConfiguration(this.getCommentGeneratorConfiguration());
                context.setJdbcConnectionConfiguration(this.getJdbcConnectionConfiguration());
                context.setJavaTypeResolverConfiguration(this.getJavaTypeResolverConfiguration());
                context.setJavaModelGeneratorConfiguration(this.getJavaModelGeneratorConfiguration());
                if (!this.noXml) {
                    context.setSqlMapGeneratorConfiguration(this.getSqlMapGeneratorConfiguration());
                }
                context.setJavaClientGeneratorConfiguration(this.getJavaClientGeneratorConfiguration());
                this.addTableConfiguration(context);
                config.addContext(context);
            }
            DefaultShellCallback callback = new DefaultShellCallback(this.overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate(null);
            for (String warning : warnings) {
                this.getLog().warn((CharSequence)warning);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTableConfiguration(Context context) {
        if (Objects.equals(this.tableNames, all)) {
            context.addTableConfiguration(this.getTableConfiguration(context, "%", null));
        } else {
            String[] split = this.tableNames.trim().split(",");
            for (int i = 0; i < split.length; ++i) {
                String table = split[i];
                if (!StringUtility.stringHasValue((String)table)) continue;
                context.addTableConfiguration(this.getTableConfiguration(context, table, null));
            }
        }
    }

    private TableConfiguration getTableConfiguration(Context context, String tableName, String domainName) {
        TableConfiguration configuration = new TableConfiguration(context);
        configuration.setTableName(tableName);
        if (StringUtility.stringHasValue((String)domainName)) {
            configuration.setDomainObjectName(domainName);
        }
        configuration.setDeleteByExampleStatementEnabled(false);
        configuration.setUpdateByExampleStatementEnabled(false);
        configuration.setSelectByExampleStatementEnabled(false);
        configuration.setCountByExampleStatementEnabled(false);
        GeneratedKey generatedKey = new GeneratedKey("id", "Mysql", true, "post");
        configuration.setGeneratedKey(generatedKey);
        return configuration;
    }

    private JavaClientGeneratorConfiguration getJavaClientGeneratorConfiguration() {
        JavaClientGeneratorConfiguration configuration = new JavaClientGeneratorConfiguration();
        configuration.setTargetPackage(this.basePackage + ".mapper");
        configuration.setTargetProject(targetProject);
        if (this.noXml) {
            configuration.setConfigurationType("ANNOTATEDMAPPER");
        } else {
            configuration.setConfigurationType("XMLMAPPER");
        }
        return configuration;
    }

    private SqlMapGeneratorConfiguration getSqlMapGeneratorConfiguration() {
        SqlMapGeneratorConfiguration configuration = new SqlMapGeneratorConfiguration();
        configuration.setTargetPackage("mapper");
        configuration.setTargetProject(targetResources);
        return configuration;
    }

    private JavaModelGeneratorConfiguration getJavaModelGeneratorConfiguration() {
        JavaModelGeneratorConfiguration configuration = new JavaModelGeneratorConfiguration();
        configuration.setTargetPackage(this.basePackage + ".model");
        configuration.setTargetProject(targetProject);
        return configuration;
    }

    private JavaTypeResolverConfiguration getJavaTypeResolverConfiguration() {
        JavaTypeResolverConfiguration configuration = new JavaTypeResolverConfiguration();
        configuration.addProperty("forceBigDecimals", "false");
        return configuration;
    }

    private CommentGeneratorConfiguration getCommentGeneratorConfiguration() {
        CommentGeneratorConfiguration configuration = new CommentGeneratorConfiguration();
        configuration.addProperty("suppressDate", "true");
        return configuration;
    }

    private void addServicePluginConfigurationToContext(Context context) {
        String filePlugin = "tk.mybatis.mapper.generator.TemplateFilePlugin";
        HashMap<String, String> dtoProperties = new HashMap<String, String>();
        dtoProperties.put("targetProject", targetProject);
        dtoProperties.put("targetPackage", this.basePackage + ".dto");
        dtoProperties.put("templatePath", "templates/dto.ftl");
        dtoProperties.put("mapperSuffix", "Dto");
        dtoProperties.put("fileName", "${tableClass.shortClassName}${mapperSuffix}.java");
        context.addPluginConfiguration(this.getPluginConfiguration(filePlugin, dtoProperties));
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("targetProject", targetProject);
        serviceProperties.put("targetPackage", this.basePackage + ".service");
        serviceProperties.put("templatePath", "templates/service.ftl");
        serviceProperties.put("mapperSuffix", "Service");
        serviceProperties.put("fileName", "${tableClass.shortClassName}${mapperSuffix}.java");
        context.addPluginConfiguration(this.getPluginConfiguration(filePlugin, serviceProperties));
        HashMap<String, String> serviceImplProperties = new HashMap<String, String>();
        serviceImplProperties.put("targetProject", targetProject);
        serviceImplProperties.put("targetPackage", this.basePackage + ".service.impl");
        serviceImplProperties.put("templatePath", "templates/serviceImpl.ftl");
        serviceImplProperties.put("mapperSuffix", "ServiceImpl");
        serviceImplProperties.put("fileName", "${tableClass.shortClassName}${mapperSuffix}.java");
        context.addPluginConfiguration(this.getPluginConfiguration(filePlugin, serviceImplProperties));
    }

    private void addPluginConfigurationToContext(Context context) {
        String serializablePlugin = "org.mybatis.generator.plugins.SerializablePlugin";
        context.addPluginConfiguration(this.getPluginConfiguration(serializablePlugin, null));
        String mapperPlugin = "tk.mybatis.mapper.generator.MapperPlugin";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("mappers", this.xMapper);
        properties.put("caseSensitive", "true");
        properties.put("lombok", "Data");
        properties.put("generateColumnConsts", "true");
        context.addPluginConfiguration(this.getPluginConfiguration(mapperPlugin, properties));
    }

    private PluginConfiguration getPluginConfiguration(String type, Map<String, String> properties) {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setConfigurationType(type);
        if (properties != null && !properties.isEmpty()) {
            Set<String> keySet = properties.keySet();
            for (String key : keySet) {
                pluginConfiguration.addProperty(key, properties.get(key));
            }
        }
        return pluginConfiguration;
    }

    private JDBCConnectionConfiguration getJdbcConnectionConfiguration() {
        JDBCConnectionConfiguration connectionConfiguration = new JDBCConnectionConfiguration();
        connectionConfiguration.setDriverClass(this.jdbcDriver);
        connectionConfiguration.setConnectionURL(this.jdbcURL);
        connectionConfiguration.setUserId(this.jdbcUserId);
        connectionConfiguration.setPassword(this.jdbcPassword);
        return connectionConfiguration;
    }
}

