/*
 * Decompiled with CFR 0.152.
 */
package com.github.wiselenium.elements.page;

import com.github.wiselenium.Wiselenium;
import com.github.wiselenium.elements.WiseQuery;
import com.github.wiselenium.elements.page.ScreenShotException;
import com.github.wiselenium.elements.page.WiseScreenShoot;
import com.github.wiselenium.elements.page.WiseWait;
import com.github.wiselenium.factory.WisePageFactory;
import com.github.wiselenium.factory.annotation.Root;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.support.ui.LoadableComponent;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Page
extends LoadableComponent<Page>
implements WrapsDriver,
WiseQuery,
WiseWait,
WiseScreenShoot {
    @Root
    private WebDriver driver;

    public Page() {
    }

    public Page(WebDriver driver) {
        this.driver = driver;
    }

    public <E> E initNextPage(Class<E> clazz) {
        return (E)WisePageFactory.initElements((WebDriver)this.driver, clazz);
    }

    public Object executeScript(String script) {
        return ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public <E> E findElement(Class<E> clazz, By by) {
        return (E)Wiselenium.findElement(clazz, (By)by, (SearchContext)this.driver);
    }

    @Override
    public <E> List<E> findElements(Class<E> clazz, By by) {
        return Wiselenium.findElements(clazz, (By)by, (SearchContext)this.driver);
    }

    @Override
    public WebDriverWait waitFor(long timeOutInSeconds) {
        return new WebDriverWait(this.driver, timeOutInSeconds);
    }

    @Override
    public WebDriverWait waitFor(long timeOutInSeconds, long sleepInMillis) {
        return new WebDriverWait(this.driver, timeOutInSeconds, sleepInMillis);
    }

    @Override
    public void takeScreenShot(String fileName) {
        File scrFile = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            throw new ScreenShotException(e);
        }
    }

    protected void load() {
    }

    protected void isLoaded() {
    }
}

