/*
 * Decompiled with CFR 0.152.
 */
package com.github.wiselenium.testng;

import com.github.wiselenium.WiseContext;
import com.github.wiselenium.Wiselenium;
import com.github.wiselenium.factory.WisePageFactory;
import com.github.wiselenium.testng.WiseQuery;
import com.github.wiselenium.testng.WiseScreenShoot;
import com.github.wiselenium.testng.WiseTestListener;
import com.github.wiselenium.testng.WiseWait;
import com.github.wiselenium.testng.annotation.Page;
import com.github.wiselenium.testng.exception.PageInjectionException;
import com.github.wiselenium.testng.exception.ScreenShotException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;

@Listeners(value={WiseTestListener.class})
public class WiseTest
implements WiseQuery,
WiseWait,
WiseScreenShoot {
    private WebDriver driver;

    @BeforeClass
    public void setUpWiseTest() {
        this.driver = this.initDriver();
        WiseContext.setDriver((WebDriver)this.driver);
        this.injectPageFieldsIntoTest(this);
    }

    @AfterClass(alwaysRun=true)
    public void tearDownWiseTest() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    public WebDriver initDriver() {
        return new FirefoxDriver();
    }

    private void injectPageFieldsIntoTest(WiseTest testInstance) {
        Class<?> clazz = testInstance.getClass();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                this.injectPageFieldIntoTest(field, testInstance);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void injectPageFieldIntoTest(Field field, WiseTest testInstance) {
        if (!field.isAnnotationPresent(Page.class)) {
            return;
        }
        field.setAccessible(true);
        Class<?> page = testInstance.initElements((Object)field.getType());
        try {
            field.set(testInstance, page);
        }
        catch (Exception e) {
            throw new PageInjectionException(field.getType(), this.getClass(), e);
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public <E> E findElement(Class<E> clazz, By by) {
        return (E)Wiselenium.findElement(clazz, (By)by, (SearchContext)this.driver);
    }

    @Override
    public <E> List<E> findElements(Class<E> clazz, By by) {
        return Wiselenium.findElements(clazz, (By)by, (SearchContext)this.driver);
    }

    public void get(String url) {
        if (url != null) {
            this.driver.get(url);
        }
    }

    public <E> E initElements(Class<E> clazz) {
        return (E)WisePageFactory.initElements((WebDriver)this.driver, clazz);
    }

    public <E> E initElements(E instance) {
        return (E)WisePageFactory.initElements((SearchContext)this.driver, instance);
    }

    @Override
    public WebDriverWait waitFor(long timeOutInSeconds) {
        return new WebDriverWait(this.driver, timeOutInSeconds);
    }

    @Override
    public WebDriverWait waitFor(long timeOutInSeconds, long sleepInMillis) {
        return new WebDriverWait(this.driver, timeOutInSeconds, sleepInMillis);
    }

    @Override
    public void takeScreenShot(String fileName) {
        File scrFile = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            throw new ScreenShotException(e);
        }
    }

    public String getTestFailureScreenShotPath() {
        return "target/test-failure-screenshots/";
    }
}

