/*
 * Decompiled with CFR 0.152.
 */
package com.github.wiselenium.testng;

import com.github.wiselenium.testng.WiseTest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class WiseTestListener
extends TestListenerAdapter {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public void onTestFailure(ITestResult tr) {
        Object testInstance = tr.getInstance();
        if (testInstance instanceof WiseTest) {
            String fileName = String.format("%s/%s_%s_%s.png", ((WiseTest)testInstance).getTestFailureScreenShotPath(), testInstance.getClass().getSimpleName(), tr.getMethod().getMethodName(), DATE_FORMAT.format(Calendar.getInstance().getTime()));
            ((WiseTest)testInstance).takeScreenShot(fileName);
        }
    }
}

