/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JUnit5Reporter
implements Reporter {
    private final String JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";

    @Override
    public void mismatch(ApprovalFiles files) {
        try {
            Class<?> assertionsClass = Class.forName("org.junit.jupiter.api.Assertions");
            Method assertEquals = assertionsClass.getMethod("assertEquals", Object.class, Object.class, String.class);
            assertEquals.invoke(null, files.approvedContent(), files.receivedContent(), String.format("%s differs from %s", files.received, files.approved));
        }
        catch (InvocationTargetException e) {
            throw (AssertionError)((Object)e.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("org.junit.jupiter.api.Assertions");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

