/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.utils.CommandFinder;
import com.github.writethemfirst.approvals.utils.ExecutableCommand;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;

public class CommandReporter
implements Reporter {
    final String[] arguments;
    private static final String DEFAULT_ARGUMENTS = "%received% %approved%";
    final ExecutableCommand executableCommand;
    private final boolean available;

    public CommandReporter(ExecutableCommand command, String ... arguments) {
        this.available = command.isAvailable();
        this.executableCommand = command;
        this.arguments = arguments;
    }

    public CommandReporter(CommandFinder command) {
        this(command, DEFAULT_ARGUMENTS);
    }

    public CommandReporter(CommandFinder command, String arguments) {
        this(command, arguments.split(" "));
    }

    private CommandReporter(CommandFinder command, String ... arguments) {
        this.arguments = arguments;
        Optional<ExecutableCommand> executableCommand = command.executableCommand();
        if (executableCommand.isPresent()) {
            this.executableCommand = executableCommand.get();
            this.available = this.executableCommand.isAvailable();
        } else {
            this.available = false;
            this.executableCommand = null;
        }
    }

    @Override
    public void mismatch(ApprovalFiles files) {
        try {
            this.executableCommand.execute(this.actualArguments(files.approved.toAbsolutePath(), files.received.toAbsolutePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    private String[] actualArguments(Path approved, Path received) {
        return (String[])Arrays.stream(this.arguments).map(elt -> this.prepareCommandElement(approved, received, (String)elt)).toArray(String[]::new);
    }

    private String prepareCommandElement(Path approved, Path received, String elt) {
        return elt.replace("%approved%", approved.toString()).replace("%received%", received.toString());
    }
}

