/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public class StringUtils {
    public static boolean sameContent(String expected, String actual) {
        List<String> expectedElements = StringUtils.splitOnLineEndings(expected);
        List<String> actualElements = StringUtils.splitOnLineEndings(actual);
        return expectedElements.size() == actualElements.size() && IntStream.range(0, expectedElements.size()).allMatch(i -> ((String)expectedElements.get(i)).equals(actualElements.get(i)));
    }

    public static List<String> splitOnLineEndings(String s) {
        return Arrays.asList(s.split("\r\n|\n"));
    }

    public static String describeDifferences(String expected, String actual) {
        int actualSize;
        List<String> expectedList = StringUtils.splitOnLineEndings(expected);
        List<String> actualList = StringUtils.splitOnLineEndings(actual);
        int expectedSize = expectedList.size();
        if (expectedSize != (actualSize = actualList.size())) {
            return String.format("expected:%n%s%n(%d lines) but was:%n%s%n(%d lines)", expected, expectedSize, actual, actualSize);
        }
        if (expectedSize == 1) {
            return StringUtils.describeDifferentLines(expected, actual, 0);
        }
        int lineIndex = StringUtils.firstDifferentLine(expectedList, actualList);
        return String.format("expected:%n%s%n but was:%n%s%n", expected, actual) + StringUtils.describeDifferentLines(expectedList.get(lineIndex), actualList.get(lineIndex), lineIndex);
    }

    private static String describeDifferentLines(String expected, String actual, Integer lineIndex) {
        String prefix = StringUtils.greatestCommonPrefix(expected, actual);
        String suffix = StringUtils.greatestCommonSuffix(expected.substring(prefix.length()), actual.substring(prefix.length()));
        String expectedCenter = expected.substring(prefix.length(), expected.length() - suffix.length());
        String actualCenter = actual.substring(prefix.length(), actual.length() - suffix.length());
        return String.format("first difference at line#%d col#%d: expected %s[%s]%s but was %s[%s]%s", lineIndex, prefix.length(), prefix, expectedCenter, suffix, prefix, actualCenter, suffix);
    }

    private static int firstDifferentLine(List<String> expectedList, List<String> actualList) {
        for (int i = 0; i < expectedList.size(); ++i) {
            if (expectedList.get(i).equals(actualList.get(i))) continue;
            return i;
        }
        throw new RuntimeException("no differences !");
    }

    private static String greatestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }

    private static String greatestCommonSuffix(String a, String b) {
        int aLength = a.length();
        int bLength = b.length();
        int minLength = Math.min(aLength, bLength);
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(aLength - i - 1) == b.charAt(bLength - i - 1)) continue;
            return a.substring(aLength - i);
        }
        return a.substring(aLength - minLength);
    }
}

