/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.files;

import com.github.writethemfirst.approvals.files.ApprovalFolders;
import com.github.writethemfirst.approvals.utils.FileUtils;
import com.github.writethemfirst.approvals.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class ApprovalFiles {
    public final Path approved;
    public final Path received;

    public ApprovalFiles(Path folder, String methodName) {
        this(ApprovalFiles.approvalFilePath(folder, methodName, "approved"), ApprovalFiles.approvalFilePath(folder, methodName, "received"));
    }

    public ApprovalFiles(Path approved, Path received) {
        this.approved = approved;
        this.received = received;
    }

    public String approvedContent() {
        return FileUtils.silentRead(this.approved);
    }

    public String receivedContent() {
        return FileUtils.silentRead(this.received);
    }

    public boolean hasApproved(String content) {
        return StringUtils.sameContent(this.approvedContent(), content);
    }

    public boolean hasReceived(String content) {
        return StringUtils.sameContent(this.receivedContent(), content);
    }

    boolean haveSameContent() {
        return StringUtils.sameContent(this.approvedContent(), this.receivedContent());
    }

    public void createEmptyApprovedFileIfNeeded() {
        File file = this.approved.toFile();
        if (!file.exists()) {
            try {
                FileUtils.createParentDirectories(this.approved);
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can't create an empty file at <%s>.", file), e);
            }
        }
    }

    ApprovalFolders parent() {
        return new ApprovalFolders(this.approved.getParent(), this.received.getParent());
    }

    static Path approvalFilePath(Path folder, String methodName, String extension) {
        return folder.resolve(String.format("%s.%s", methodName.replaceAll("[^a-zA-Z0-9-]", "_"), extension));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApprovalFiles)) {
            return false;
        }
        ApprovalFiles that = (ApprovalFiles)o;
        return this.approved.equals(that.approved) && this.received.equals(that.received);
    }

    public int hashCode() {
        int result = this.approved.hashCode();
        result = 31 * result + this.received.hashCode();
        return result;
    }
}

