/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.reporters.CommandReporter;
import com.github.writethemfirst.approvals.reporters.SupportedOs;
import com.github.writethemfirst.approvals.utils.ExecutableCommand;
import com.github.writethemfirst.approvals.utils.FileUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ReporterConfiguration {
    private static final String commentCharacter = "#";
    private static String separator = "////";
    private static String home = System.getProperty("user.home");
    static Path dotFile = Paths.get(home, ".approvals-java");

    ReporterConfiguration() {
    }

    static Optional<CommandReporter> read() {
        if (dotFile.toFile().exists()) {
            try {
                return ReporterConfiguration.parse(FileUtils.silentRead(dotFile));
            }
            catch (RuntimeException e) {
                System.err.println(String.format("Could not parse configuration %s, using defaults", dotFile));
                System.err.println(e);
                return Optional.empty();
            }
        }
        ReporterConfiguration.write();
        System.out.println(String.format("Initialized %s, uncomment lines to select your preferred command", dotFile));
        return Optional.empty();
    }

    static Optional<CommandReporter> parse(String configurationContent) {
        return ReporterConfiguration.parseReporters(configurationContent).filter(Reporter::isAvailable).findFirst();
    }

    static Stream<CommandReporter> parseReporters(String configurationContent) {
        String lineEndingsRegexp = "\n|\r\n";
        return Stream.of(configurationContent.split("\n|\r\n")).map(String::trim).filter(line -> !line.startsWith(commentCharacter)).map(ReporterConfiguration::parseLine);
    }

    private static CommandReporter parseLine(String line) {
        String[] split = line.split(separator);
        String exec = split[0].trim();
        String[] args = split[1].trim().split(" ");
        return new CommandReporter(new ExecutableCommand(exec), args);
    }

    static void write() {
        SupportedOs.activeOs().ifPresent(os -> FileUtils.write(os.specs.stream().flatMap(s -> s.finder().searchForAllExe().map(e -> String.format("# %s %s %s%n", e, separator, String.join((CharSequence)" ", s.arguments)))).collect(Collectors.joining("")), dotFile));
    }
}

