/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;

public class ExecutableCommand {
    private final Runtime runtime;
    public final String executable;

    public ExecutableCommand(String executable) {
        this(executable, Runtime.getRuntime());
    }

    ExecutableCommand(String executable, Runtime runtime) {
        this.executable = executable;
        this.runtime = runtime;
    }

    public void execute(String ... arguments) throws IOException {
        CharSequence[] cmdArray = this.buildCommandArray(arguments);
        System.out.printf("Running command [%s]%n", String.join((CharSequence)" ", cmdArray));
        try {
            this.runtime.exec((String[])cmdArray).waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] buildCommandArray(String[] arguments) {
        return (String[])Stream.concat(Stream.of(this.executable), Arrays.stream(arguments)).toArray(String[]::new);
    }

    public boolean isAvailable() {
        File file = Paths.get(this.executable, new String[0]).toFile();
        return file.exists() && file.canExecute();
    }
}

