/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class FileVisitorWithResult
extends SimpleFileVisitor<Path> {
    Stream<Path> result = Stream.empty();
    private BiPredicate<Path, BasicFileAttributes> matcher;

    public FileVisitorWithResult(BiPredicate<Path, BasicFileAttributes> pMatcher) {
        this.matcher = pMatcher;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.matcher.test(file, attrs)) {
            this.result = Stream.concat(this.result, Stream.of(file));
        }
        return super.visitFile(file, attrs);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc instanceof FileSystemLoopException) {
            return FileVisitResult.CONTINUE;
        }
        return super.visitFileFailed(file, exc);
    }
}

