/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils.stack;

import com.github.writethemfirst.approvals.utils.stack.FindCaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaDefaultFindCaller
implements FindCaller {
    private static String firstMatchingCallerClass(List<String> classesInStack, Class<?>[] potentialReferenceClasses) {
        ArrayList<String> reversedStack = new ArrayList<String>(classesInStack);
        Collections.reverse(reversedStack);
        Optional<String> lastReferenceName = reversedStack.stream().filter(className -> Arrays.stream(potentialReferenceClasses).anyMatch(referenceClass -> className.equals(referenceClass.getName()))).findFirst();
        if (lastReferenceName.isPresent()) {
            int referenceIndex = classesInStack.indexOf(lastReferenceName.get());
            if (referenceIndex + 1 < classesInStack.size()) {
                return classesInStack.get(referenceIndex + 1);
            }
            System.err.println("Reference class is found but appears to have no parent in the current stack trace...");
        } else {
            System.err.println("Can't locate any of the provided reference classes in the current stack trace...");
        }
        return "";
    }

    private static List<String> distinctClassesInStack() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).distinct().collect(Collectors.toList());
    }

    @Override
    public String callerClass(Class<?> ... potentialReferenceClasses) {
        List<String> classesInStack = JavaDefaultFindCaller.distinctClassesInStack();
        return JavaDefaultFindCaller.firstMatchingCallerClass(classesInStack, potentialReferenceClasses);
    }

    @Override
    public Optional<String> callerMethod(String referenceClassName) {
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(e -> e.getClassName().equals(referenceClassName)).filter(e -> !e.getMethodName().startsWith("lambda$")).map(StackTraceElement::getMethodName).findFirst();
    }
}

