/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals;

import com.github.writethemfirst.approvals.ApprobationContext;
import com.github.writethemfirst.approvals.utils.StackUtils;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ApprovalsFiles {
    private final Class<?> testClass;

    public ApprovalsFiles() {
        this(StackUtils.callerClass(ApprovalsFiles.class));
    }

    ApprovalsFiles(Class<?> testClass) {
        this.testClass = testClass;
    }

    public ApprobationContext defaultContext() {
        return new ApprobationContext(this.folderForClass(), this.callerMethodName());
    }

    public ApprobationContext context(String methodName) {
        return new ApprobationContext(this.folderForClass(), methodName);
    }

    private Path folderForClass() {
        String packageName = this.testClass.getPackage().getName();
        Path packageResourcesPath = Paths.get("src/test/resources/", packageName.split("\\."));
        return packageResourcesPath.resolve(this.testClass.getSimpleName());
    }

    private String callerMethodName() {
        return StackUtils.callerMethod(this.testClass).orElse("unknown_method");
    }
}

