/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    public static String silentRead(Path file) {
        try {
            return new String(Files.readAllBytes(file));
        }
        catch (IOException e) {
            System.err.println("Could not read from " + file);
            return "";
        }
    }

    public static void silentRemove(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            System.err.println("Warning: couldn't remove the file located at: " + file);
        }
    }

    public static void silentRemoveRec(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtils.silentRemoveRec(child);
            }
        }
        file.delete();
    }

    public static void write(String content, Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Error: cannot create directories for: " + file);
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write(content);
        }
        catch (IOException e) {
            String message = String.format("Could not write to file %s because of %s", file.toAbsolutePath(), e);
            throw new RuntimeException(message, e);
        }
    }

    public static void copy(Path fromFile, Path toFile) {
        FileUtils.write(FileUtils.silentRead(fromFile), toFile);
    }
}

