/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.approvers;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.approvers.Approver;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.utils.FileUtils;
import com.github.writethemfirst.approvals.utils.FunctionUtils;
import com.github.writethemfirst.approvals.utils.functions.Function1;
import com.github.writethemfirst.approvals.utils.functions.Function2;
import com.github.writethemfirst.approvals.utils.functions.Function3;
import com.github.writethemfirst.approvals.utils.functions.Function4;
import com.github.writethemfirst.approvals.utils.functions.Function5;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CombinationApprover
extends Approver {
    private final String header;

    public CombinationApprover() {
        this.header = "";
    }

    @Override
    public CombinationApprover reportTo(Reporter reporter) {
        return new CombinationApprover(reporter, this.customFileName, this.customExtension, this.header, this.testClass);
    }

    @Override
    public CombinationApprover writeTo(String customFileName) {
        return new CombinationApprover(this.reporter, customFileName, this.customExtension, this.header, this.testClass);
    }

    @Override
    public CombinationApprover testing(Class<?> testClass) {
        return new CombinationApprover(this.reporter, this.customFileName, this.customExtension, this.header, testClass);
    }

    public CombinationApprover namedArguments(String ... names) {
        return this.header(Arrays.stream(names).collect(Collectors.joining(", ", "result, ", "\n")));
    }

    private CombinationApprover(Reporter reporter, String customFileName, String customExtension, String headerWithLineFeed, Class<?> testClass) {
        super(reporter, customFileName, customExtension, testClass);
        this.header = headerWithLineFeed;
    }

    private CombinationApprover csv() {
        return new CombinationApprover(this.reporter, this.customFileName, ".csv", this.header, this.testClass);
    }

    private CombinationApprover header(String headerWithLineFeed) {
        return new CombinationApprover(this.reporter, this.customFileName, this.customExtension, headerWithLineFeed, this.testClass);
    }

    @Override
    void writeReceivedFile(Object output, ApprovalFiles files) {
        FileUtils.write(this.header + output, files.received);
    }

    public <I1> void verifyAllCombinations(Iterable<I1> args1, Function1<I1, ?> f) {
        this.csv().verify(FunctionUtils.applyCombinations(args1, f));
    }

    public <I1> void verifyAllCombinations(I1[] args1, Function1<I1, ?> f) {
        this.verifyAllCombinations(Arrays.asList(args1), f);
    }

    public <I1, I2> void verifyAllCombinations(Iterable<I1> args1, Iterable<I2> args2, Function2<I1, I2, ?> f) {
        this.csv().verify(FunctionUtils.applyCombinations(args1, args2, f));
    }

    public <I1, I2> void verifyAllCombinations(I1[] args1, I2[] args2, Function2<I1, I2, ?> f) {
        this.verifyAllCombinations(Arrays.asList(args1), Arrays.asList(args2), f);
    }

    public <I1, I2, I3> void verifyAllCombinations(Iterable<I1> args1, Iterable<I2> args2, Iterable<I3> args3, Function3<I1, I2, I3, ?> f) {
        this.csv().verify(FunctionUtils.applyCombinations(args1, args2, args3, f));
    }

    public <I1, I2, I3> void verifyAllCombinations(I1[] args1, I2[] args2, I3[] args3, Function3<I1, I2, I3, ?> f) {
        this.verifyAllCombinations(Arrays.asList(args1), Arrays.asList(args2), Arrays.asList(args3), f);
    }

    public <I1, I2, I3, I4> void verifyAllCombinations(Iterable<I1> args1, Iterable<I2> args2, Iterable<I3> args3, Iterable<I4> args4, Function4<I1, I2, I3, I4, ?> f) {
        this.csv().verify(FunctionUtils.applyCombinations(args1, args2, args3, args4, f));
    }

    public <I1, I2, I3, I4> void verifyAllCombinations(I1[] args1, I2[] args2, I3[] args3, I4[] args4, Function4<I1, I2, I3, I4, ?> f) {
        this.verifyAllCombinations(Arrays.asList(args1), Arrays.asList(args2), Arrays.asList(args3), Arrays.asList(args4), f);
    }

    public <I1, I2, I3, I4, I5> void verifyAllCombinations(Iterable<I1> args1, Iterable<I2> args2, Iterable<I3> args3, Iterable<I4> args4, Iterable<I5> args5, Function5<I1, I2, I3, I4, I5, ?> f) {
        this.csv().verify(FunctionUtils.applyCombinations(args1, args2, args3, args4, args5, f));
    }

    public <I1, I2, I3, I4, I5> void verifyAllCombinations(I1[] args1, I2[] args2, I3[] args3, I4[] args4, I5[] args5, Function5<I1, I2, I3, I4, I5, ?> f) {
        this.verifyAllCombinations(Arrays.asList(args1), Arrays.asList(args2), Arrays.asList(args3), Arrays.asList(args4), Arrays.asList(args5), f);
    }
}

