/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.approvers;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.approvers.Approver;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.reporters.ThrowsReporter;
import com.github.writethemfirst.approvals.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FolderApprover
extends Approver {
    public FolderApprover() {
    }

    @Override
    public FolderApprover reportTo(Reporter reporter) {
        return new FolderApprover(reporter, this.customFileName, this.customExtension, this.testClass);
    }

    @Override
    public FolderApprover writeTo(String customFileName) {
        return new FolderApprover(this.reporter, customFileName, this.customExtension, this.testClass);
    }

    @Override
    public FolderApprover testing(Class<?> testClass) {
        return new FolderApprover(this.reporter, this.customFileName, this.customExtension, testClass);
    }

    private FolderApprover(Reporter reporter, String customFileName, String customExtension, Class<?> testClass) {
        super(reporter, customFileName, customExtension, testClass);
    }

    public void verifyAllFiles(Path actualFolder) {
        ApprovalFiles approvalFiles = this.approvedAndReceivedPaths();
        this.prepareFolders(actualFolder, approvalFiles);
        Map<Boolean, List<ApprovalFiles>> matchesAndMismatches = approvalFiles.listChildrenApprovalFiles().collect(Collectors.partitioningBy(ApprovalFiles::haveSameContent));
        this.cleanupReceivedFiles(approvalFiles, matchesAndMismatches);
        this.reportMismatches(matchesAndMismatches);
        this.throwMismatches(matchesAndMismatches);
    }

    private void reportMismatches(Map<Boolean, List<ApprovalFiles>> matchesAndMismatches) {
        matchesAndMismatches.get(false).forEach(mismatch -> this.reporter.mismatch(mismatch.approved, mismatch.received));
    }

    private void throwMismatches(Map<Boolean, List<ApprovalFiles>> matchesAndMismatches) {
        matchesAndMismatches.get(false).forEach(mismatch -> new ThrowsReporter().mismatch(mismatch.approved, mismatch.received));
    }

    private void cleanupReceivedFiles(ApprovalFiles approvalFiles, Map<Boolean, List<ApprovalFiles>> matchesAndMismatches) {
        matchesAndMismatches.get(true).forEach(ar -> FileUtils.silentRemove(ar.received));
        if (matchesAndMismatches.get(false).isEmpty()) {
            FileUtils.silentRecursiveRemove(approvalFiles.received);
        }
    }

    private void prepareFolders(Path actualFolder, ApprovalFiles approvalFiles) {
        try {
            Files.createDirectories(approvalFiles.approved, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("could not create *approved* folder " + approvalFiles.approved, e);
        }
        FileUtils.listFiles(actualFolder).forEach(p -> FileUtils.copyToFolder(p, approvalFiles.received));
        approvalFiles.listChildrenApprovalFiles().map(paths -> paths.approved).forEach(FileUtils::createFileIfNeeded);
    }
}

