/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.approvers;

import com.github.writethemfirst.approvals.Approvals;
import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.files.ApprovalFolders;
import com.github.writethemfirst.approvals.files.MatchesAndMismatches;
import com.github.writethemfirst.approvals.reporters.ThrowsReporter;
import com.github.writethemfirst.approvals.utils.FileUtils;
import com.github.writethemfirst.approvals.utils.StackUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Approver {
    private final Class<?> testClass;
    private final Path folder;
    private final Reporter reporter;
    private final String customFileName;
    private final String customExtension;
    private final String header;

    public Approver() {
        this(Reporter.DEFAULT, null, "", StackUtils.callerClass(Approver.class, Approvals.class), "");
    }

    private Approver(Reporter reporter, String customFileName, String customExtension, Class<?> testClass, String header) {
        this.reporter = reporter;
        this.customFileName = customFileName;
        this.customExtension = customExtension;
        this.testClass = testClass;
        this.folder = Approver.folderForClass(testClass);
        this.header = header;
    }

    public Approver reportTo(Reporter reporter) {
        return new Approver(reporter, this.customFileName, this.customExtension, this.testClass, this.header);
    }

    public Approver writeTo(String customFileName) {
        return new Approver(this.reporter, customFileName, this.customExtension, this.testClass, this.header);
    }

    public Approver testing(Class<?> testClass) {
        return new Approver(this.reporter, this.customFileName, this.customExtension, testClass, this.header);
    }

    public Approver namedArguments(String ... names) {
        return this.header(Arrays.stream(names).collect(Collectors.joining(", ", "result, ", "\n")));
    }

    private Approver header(String headerWithLineFeed) {
        return new Approver(this.reporter, this.customFileName, this.customExtension, this.testClass, headerWithLineFeed);
    }

    private void writeReceivedFile(Object output, ApprovalFiles files) {
        FileUtils.write(this.header + output, files.received);
    }

    public void verify(Object output) {
        ApprovalFiles approvalFiles = this.approvedAndReceivedPaths();
        this.writeReceivedFile(output, approvalFiles);
        this.verifySimpleFile(approvalFiles);
    }

    public void verify(Path output) {
        if (output.toFile().isDirectory()) {
            ApprovalFolders approvalFolders = this.approvedAndReceivedPathsForFolder();
            approvalFolders.prepareFolders(output);
            this.verifyFolderContent(approvalFolders);
        } else {
            ApprovalFiles files = this.approvedAndReceivedPathsForFolder(output);
            FileUtils.copy(output, files.received);
            this.verifySimpleFile(files);
        }
    }

    private void verifyFolderContent(ApprovalFolders approvalFolders) {
        MatchesAndMismatches matchesAndMismatches = approvalFolders.matchesAndMismatches();
        matchesAndMismatches.cleanupReceivedFiles();
        matchesAndMismatches.reportMismatches(this.reporter);
        matchesAndMismatches.throwMismatches();
    }

    private void verifySimpleFile(ApprovalFiles files) {
        if (files.haveSameContent()) {
            FileUtils.silentRemove(files.received);
        } else {
            files.createEmptyApprovedFileIfNeeded();
            this.reporter.mismatch(files);
            new ThrowsReporter().mismatch(files);
        }
    }

    private static Path folderForClass(Class<?> testClass) {
        String packageName = testClass.getPackage().getName();
        Path packageResourcesPath = Paths.get("src/test/resources/", packageName.split("\\."));
        return packageResourcesPath.resolve(testClass.getSimpleName());
    }

    private String callerMethodName() {
        return StackUtils.callerMethod(this.testClass).orElse("unknown_method");
    }

    private ApprovalFiles approvedAndReceivedPathsForFolder(Path output) {
        return this.approvedAndReceivedPathsForFolder().resolve(output);
    }

    private ApprovalFolders approvedAndReceivedPathsForFolder() {
        String methodName = this.customFileName != null ? this.customFileName : this.callerMethodName();
        return new ApprovalFolders(this.folder, methodName);
    }

    private ApprovalFiles approvedAndReceivedPaths() {
        String methodName = this.customFileName != null ? this.customFileName : this.callerMethodName();
        return new ApprovalFiles(this.folder, methodName);
    }
}

