/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.files;

import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.files.MatchesAndMismatches;
import com.github.writethemfirst.approvals.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApprovalFolders
extends ApprovalFiles {
    public ApprovalFolders(Path folder, String methodName) {
        super(folder, methodName);
    }

    ApprovalFolders(Path approved, Path received) {
        super(approved, received);
    }

    public ApprovalFiles resolve(Path file) {
        Path fileName = file.getFileName();
        return new ApprovalFiles(this.approved.resolve(fileName), this.received.resolve(fileName));
    }

    public void prepareFolders(Path actualFolder) {
        try {
            Files.createDirectories(this.approved, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("could not create *approved* folder " + this.approved, e);
        }
        FileUtils.listFiles(actualFolder).forEach(actual -> FileUtils.copyToFolder(actual, this.received));
    }

    public MatchesAndMismatches matchesAndMismatches() {
        Map<Boolean, List<ApprovalFiles>> matchesAndMismatches = Stream.concat(FileUtils.listFiles(this.approved).map(this::matchApprovedFile), FileUtils.listFiles(this.received).map(this::matchReceivedFile)).distinct().collect(Collectors.partitioningBy(ApprovalFiles::haveSameContent));
        return new MatchesAndMismatches(matchesAndMismatches.get(true), matchesAndMismatches.get(false));
    }

    private ApprovalFiles matchApprovedFile(Path approvedFile) {
        return new ApprovalFiles(approvedFile, this.changeRoot(approvedFile, this.approved, this.received));
    }

    private ApprovalFiles matchReceivedFile(Path receivedFile) {
        return new ApprovalFiles(this.changeRoot(receivedFile, this.received, this.approved), receivedFile);
    }

    private Path changeRoot(Path file, Path initialRoot, Path newRoot) {
        return newRoot.resolve(initialRoot.relativize(file));
    }
}

